/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.quartz;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.QuietUtils;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.properties.JobClientProperties;
import com.github.ltsopensource.core.properties.TaskTrackerProperties;
import com.github.ltsopensource.jobclient.JobClient;
import com.github.ltsopensource.jobclient.JobClientBuilder;
import com.github.ltsopensource.jobclient.domain.Response;
import com.github.ltsopensource.spring.quartz.QuartzJobContext;
import com.github.ltsopensource.spring.quartz.QuartzJobRunnerDispatcher;
import com.github.ltsopensource.spring.quartz.QuartzJobType;
import com.github.ltsopensource.spring.quartz.QuartzLTSConfig;
import com.github.ltsopensource.tasktracker.TaskTracker;
import com.github.ltsopensource.tasktracker.TaskTrackerBuilder;
import com.github.ltsopensource.tasktracker.runner.JobRunner;
import com.github.ltsopensource.tasktracker.runner.RunnerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

class QuartzLTSProxyAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzLTSProxyAgent.class);
    private QuartzLTSConfig quartzLTSConfig;
    private List<QuartzJobContext> quartzJobContexts = new CopyOnWriteArrayList<QuartzJobContext>();
    private AtomicBoolean ready = new AtomicBoolean(false);

    public QuartzLTSProxyAgent(QuartzLTSConfig quartzLTSConfig) {
        this.quartzLTSConfig = quartzLTSConfig;
    }

    public void startProxy(List<QuartzJobContext> cronJobs) {
        if (CollectionUtils.isEmpty(cronJobs)) {
            return;
        }
        this.quartzJobContexts.addAll(cronJobs);
        if (!this.ready.compareAndSet(false, true)) {
            return;
        }
        new NamedThreadFactory(QuartzLTSProxyAgent.class.getSimpleName() + "_LazyStart").newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    QuietUtils.sleep((long)3000L);
                    QuartzLTSProxyAgent.this.startProxy0();
                }
                catch (Throwable t) {
                    LOGGER.error("Error on start " + QuartzLTSProxyAgent.class.getSimpleName(), t);
                }
            }
        }).start();
    }

    private void startProxy0() {
        this.startTaskTracker();
        JobClient jobClient = this.startJobClient();
        this.submitJobs(jobClient);
    }

    private void startTaskTracker() {
        TaskTracker taskTracker = TaskTrackerBuilder.buildByProperties((TaskTrackerProperties)this.quartzLTSConfig.getTaskTrackerProperties());
        taskTracker.setWorkThreads(this.quartzJobContexts.size());
        taskTracker.setJobRunnerClass(QuartzJobRunnerDispatcher.class);
        final QuartzJobRunnerDispatcher jobRunnerDispatcher = new QuartzJobRunnerDispatcher(this.quartzJobContexts);
        taskTracker.setRunnerFactory(new RunnerFactory(){

            public JobRunner newRunner() {
                return jobRunnerDispatcher;
            }
        });
        taskTracker.start();
    }

    private JobClient startJobClient() {
        JobClientProperties jobClientProperties = this.quartzLTSConfig.getJobClientProperties();
        jobClientProperties.setUseRetryClient(false);
        JobClient jobClient = JobClientBuilder.buildByProperties((JobClientProperties)jobClientProperties);
        jobClient.start();
        return jobClient;
    }

    private void submitJobs(JobClient jobClient) {
        ArrayList<Job> jobs = new ArrayList<Job>(this.quartzJobContexts.size());
        for (QuartzJobContext quartzJobContext : this.quartzJobContexts) {
            if (QuartzJobType.CRON == quartzJobContext.getType()) {
                jobs.add(this.buildCronJob(quartzJobContext));
                continue;
            }
            if (QuartzJobType.SIMPLE_REPEAT != quartzJobContext.getType()) continue;
            jobs.add(this.buildSimpleJob(quartzJobContext));
        }
        LOGGER.info("=============LTS=========== Submit start");
        this.submitJobs0(jobClient, jobs);
        LOGGER.info("=============LTS=========== Submit end");
    }

    private Job buildCronJob(QuartzJobContext quartzJobContext) {
        CronTriggerImpl cronTrigger = (CronTriggerImpl)quartzJobContext.getTrigger();
        String cronExpression = cronTrigger.getCronExpression();
        String description = cronTrigger.getDescription();
        int priority = cronTrigger.getPriority();
        String name = quartzJobContext.getName();
        Job job = new Job();
        job.setTaskId(name);
        job.setPriority(Integer.valueOf(priority));
        job.setCronExpression(cronExpression);
        job.setSubmitNodeGroup(this.quartzLTSConfig.getJobClientProperties().getNodeGroup());
        job.setTaskTrackerNodeGroup(this.quartzLTSConfig.getTaskTrackerProperties().getNodeGroup());
        job.setParam("description", description);
        this.setJobProp(job);
        return job;
    }

    private Job buildSimpleJob(QuartzJobContext quartzJobContext) {
        SimpleTriggerImpl simpleTrigger = (SimpleTriggerImpl)quartzJobContext.getTrigger();
        String description = simpleTrigger.getDescription();
        int priority = simpleTrigger.getPriority();
        String name = quartzJobContext.getName();
        int repeatCount = simpleTrigger.getRepeatCount();
        long repeatInterval = simpleTrigger.getRepeatInterval();
        Job job = new Job();
        job.setTaskId(name);
        job.setTriggerDate(simpleTrigger.getNextFireTime());
        job.setRepeatCount(repeatCount);
        if (repeatCount != 0) {
            job.setRepeatInterval(Long.valueOf(repeatInterval));
        }
        job.setPriority(Integer.valueOf(priority));
        job.setSubmitNodeGroup(this.quartzLTSConfig.getJobClientProperties().getNodeGroup());
        job.setTaskTrackerNodeGroup(this.quartzLTSConfig.getTaskTrackerProperties().getNodeGroup());
        job.setParam("description", description);
        this.setJobProp(job);
        return job;
    }

    private void setJobProp(Job job) {
        QuartzLTSConfig.JobProperties jobProperties = this.quartzLTSConfig.getJobProperties();
        if (jobProperties == null) {
            return;
        }
        if (jobProperties.getMaxRetryTimes() != null) {
            job.setMaxRetryTimes(jobProperties.getMaxRetryTimes().intValue());
        }
        if (jobProperties.getNeedFeedback() != null) {
            job.setNeedFeedback(jobProperties.getNeedFeedback().booleanValue());
        }
        if (jobProperties.getRelyOnPrevCycle() != null) {
            job.setRelyOnPrevCycle(jobProperties.getRelyOnPrevCycle().booleanValue());
        }
        if (jobProperties.getReplaceOnExist() != null) {
            job.setReplaceOnExist(jobProperties.getReplaceOnExist().booleanValue());
        }
    }

    private void submitJobs0(JobClient jobClient, List<Job> jobs) {
        List failedJobs = null;
        try {
            Response response = jobClient.submitJob(jobs);
            if (!response.isSuccess()) {
                LOGGER.warn("Submit Quartz Jobs to LTS failed: {}", new Object[]{JSON.toJSONString((Object)response)});
                failedJobs = response.getFailedJobs();
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Submit Quartz Jobs to LTS error", e);
            failedJobs = jobs;
        }
        if (CollectionUtils.isNotEmpty(failedJobs)) {
            LOGGER.info("=============LTS=========== Sleep 3 Seconds and retry");
            QuietUtils.sleep((long)3000L);
            this.submitJobs0(jobClient, failedJobs);
            return;
        }
        jobClient.stop();
    }
}

