/*
 * Decompiled with CFR 0.152.
 */
package at.markushi.ui;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import at.markushi.circlebutton.R;

public class CircleButton
extends ImageView {
    private static final int PRESSED_COLOR_LIGHTUP = 10;
    private static final int PRESSED_RING_ALPHA = 75;
    private static final int DEFAULT_PRESSED_RING_WIDTH_DIP = 4;
    private static final int ANIMATION_TIME_ID = 0x10E0000;
    private int centerY;
    private int centerX;
    private int outerRadius;
    private int pressedRingRadius;
    private Paint circlePaint;
    private Paint focusPaint;
    private float animationProgress;
    private int pressedRingWidth;
    private int defaultColor = -16777216;
    private int pressedColor;
    private ObjectAnimator pressedAnimator;

    public CircleButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircleButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public void setPressed(boolean pressed) {
        super.setPressed(pressed);
        if (this.circlePaint != null) {
            this.circlePaint.setColor(pressed ? this.pressedColor : this.defaultColor);
        }
        if (pressed) {
            this.showPressedRing();
        } else {
            this.hidePressedRing();
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawCircle((float)this.centerX, (float)this.centerY, (float)this.pressedRingRadius + this.animationProgress, this.focusPaint);
        canvas.drawCircle((float)this.centerX, (float)this.centerY, (float)(this.outerRadius - this.pressedRingWidth), this.circlePaint);
        super.onDraw(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.centerX = w / 2;
        this.centerY = h / 2;
        this.outerRadius = Math.min(w, h) / 2;
        this.pressedRingRadius = this.outerRadius - this.pressedRingWidth - this.pressedRingWidth / 2;
    }

    public float getAnimationProgress() {
        return this.animationProgress;
    }

    public void setAnimationProgress(float animationProgress) {
        this.animationProgress = animationProgress;
        this.invalidate();
    }

    public void setColor(int color) {
        this.defaultColor = color;
        this.pressedColor = this.getHighlightColor(color, 10);
        this.circlePaint.setColor(this.defaultColor);
        this.focusPaint.setColor(this.defaultColor);
        this.focusPaint.setAlpha(75);
        this.invalidate();
    }

    private void hidePressedRing() {
        this.pressedAnimator.setFloatValues(new float[]{this.pressedRingWidth, 0.0f});
        this.pressedAnimator.start();
    }

    private void showPressedRing() {
        this.pressedAnimator.setFloatValues(new float[]{this.animationProgress, this.pressedRingWidth});
        this.pressedAnimator.start();
    }

    private void init(Context context, AttributeSet attrs) {
        this.setFocusable(true);
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.setClickable(true);
        this.circlePaint = new Paint(1);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.focusPaint = new Paint(1);
        this.focusPaint.setStyle(Paint.Style.STROKE);
        this.pressedRingWidth = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int color = -16777216;
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleButton);
            color = a.getColor(0, color);
            this.pressedRingWidth = (int)a.getDimension(1, (float)this.pressedRingWidth);
            a.recycle();
        }
        this.setColor(color);
        this.focusPaint.setStrokeWidth((float)this.pressedRingWidth);
        int pressedAnimationTime = this.getResources().getInteger(0x10E0000);
        this.pressedAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animationProgress", (float[])new float[]{0.0f, 0.0f});
        this.pressedAnimator.setDuration((long)pressedAnimationTime);
    }

    private int getHighlightColor(int color, int amount) {
        return Color.argb((int)Math.min(255, Color.alpha((int)color)), (int)Math.min(255, Color.red((int)color) + amount), (int)Math.min(255, Color.green((int)color) + amount), (int)Math.min(255, Color.blue((int)color) + amount));
    }
}

