/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.util.Printer;
import com.github.moduth.blockcanary.BlockCanaryContext;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.BlockInterceptor;
import com.github.moduth.blockcanary.DisplayService;
import com.github.moduth.blockcanary.SingleThreadFactory;
import com.github.moduth.blockcanary.Uploader;
import com.github.moduth.blockcanary.ui.DisplayActivity;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class BlockCanary {
    private static final String TAG = "BlockCanary";
    private static BlockCanary sInstance;
    private BlockCanaryInternals mBlockCanaryCore;
    private boolean mMonitorStarted = false;
    private static final Executor fileIoExecutor;

    private BlockCanary() {
        BlockCanaryInternals.setContext((BlockCanaryContext)BlockCanaryContext.get());
        this.mBlockCanaryCore = BlockCanaryInternals.getInstance();
        this.mBlockCanaryCore.addBlockInterceptor((BlockInterceptor)BlockCanaryContext.get());
        if (!BlockCanaryContext.get().displayNotification()) {
            return;
        }
        this.mBlockCanaryCore.addBlockInterceptor((BlockInterceptor)new DisplayService());
    }

    public static BlockCanary install(Context context, BlockCanaryContext blockCanaryContext) {
        BlockCanaryContext.init((Context)context, (BlockCanaryContext)blockCanaryContext);
        BlockCanary.setEnabled(context, DisplayActivity.class, BlockCanaryContext.get().displayNotification());
        return BlockCanary.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlockCanary get() {
        if (sInstance != null) return sInstance;
        Class<BlockCanary> clazz = BlockCanary.class;
        synchronized (BlockCanary.class) {
            if (sInstance != null) return sInstance;
            sInstance = new BlockCanary();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void start() {
        if (!this.mMonitorStarted) {
            this.mMonitorStarted = true;
            Looper.getMainLooper().setMessageLogging((Printer)this.mBlockCanaryCore.monitor);
        }
    }

    public void stop() {
        if (this.mMonitorStarted) {
            this.mMonitorStarted = false;
            Looper.getMainLooper().setMessageLogging(null);
            this.mBlockCanaryCore.stackSampler.stop();
            this.mBlockCanaryCore.cpuSampler.stop();
        }
    }

    public void upload() {
        Uploader.zipAndUpload();
    }

    public void recordStartTime() {
        PreferenceManager.getDefaultSharedPreferences((Context)BlockCanaryContext.get().provideContext()).edit().putLong("BlockCanary_StartTime", System.currentTimeMillis()).commit();
    }

    public boolean isMonitorDurationEnd() {
        long startTime = PreferenceManager.getDefaultSharedPreferences((Context)BlockCanaryContext.get().provideContext()).getLong("BlockCanary_StartTime", 0L);
        return startTime != 0L && System.currentTimeMillis() - startTime > (long)(BlockCanaryContext.get().provideMonitorDuration() * 3600 * 1000);
    }

    private static void setEnabledBlocking(Context appContext, Class<?> componentClass, boolean enabled) {
        ComponentName component = new ComponentName(appContext, componentClass);
        PackageManager packageManager = appContext.getPackageManager();
        int newState = enabled ? 1 : 2;
        packageManager.setComponentEnabledSetting(component, newState, 1);
    }

    private static void executeOnFileIoThread(Runnable runnable) {
        fileIoExecutor.execute(runnable);
    }

    private static Executor newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(new SingleThreadFactory(threadName));
    }

    private static void setEnabled(Context context, final Class<?> componentClass, final boolean enabled) {
        final Context appContext = context.getApplicationContext();
        BlockCanary.executeOnFileIoThread(new Runnable(){

            @Override
            public void run() {
                BlockCanary.setEnabledBlocking(appContext, componentClass, enabled);
            }
        });
    }

    static {
        fileIoExecutor = BlockCanary.newSingleThreadExecutor("File-IO");
    }
}

