/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.github.moduth.blockcanary.BlockInterceptor;
import com.github.moduth.blockcanary.R;
import com.github.moduth.blockcanary.internal.BlockInfo;
import com.github.moduth.blockcanary.ui.DisplayActivity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class DisplayService
implements BlockInterceptor {
    private static final String TAG = "DisplayService";

    DisplayService() {
    }

    public void onBlock(Context context, BlockInfo blockInfo) {
        Intent intent = new Intent(context, DisplayActivity.class);
        intent.putExtra("show_latest", blockInfo.timeStart);
        intent.setFlags(0x14000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
        String contentTitle = context.getString(R.string.block_canary_class_has_blocked, new Object[]{blockInfo.timeStart});
        String contentText = context.getString(R.string.block_canary_notification_message);
        this.show(context, contentTitle, contentText, pendingIntent);
    }

    @TargetApi(value=11)
    private void show(Context context, String contentTitle, String contentText, PendingIntent pendingIntent) {
        Notification notification;
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT < 11) {
            notification = new Notification();
            notification.icon = R.drawable.block_canary_notification;
            notification.when = System.currentTimeMillis();
            notification.flags |= 0x10;
            notification.defaults = 1;
            try {
                Method deprecatedMethod = notification.getClass().getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
                deprecatedMethod.invoke((Object)notification, context, contentTitle, contentText, pendingIntent);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                Log.w((String)TAG, (String)"Method not found", (Throwable)e);
            }
        } else {
            Notification.Builder builder = new Notification.Builder(context).setSmallIcon(R.drawable.block_canary_notification).setWhen(System.currentTimeMillis()).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setAutoCancel(true).setContentIntent(pendingIntent).setDefaults(1);
            notification = Build.VERSION.SDK_INT < 16 ? builder.getNotification() : builder.build();
        }
        notificationManager.notify(-558907665, notification);
    }
}

