/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.ui;

import android.text.TextUtils;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.internal.BlockInfo;
import com.github.moduth.blockcanary.internal.ProcessUtils;
import java.util.LinkedList;
import java.util.List;

final class BlockCanaryUtils {
    private static final List<String> WHITE_LIST = new LinkedList<String>();
    private static final List<String> CONCERN_LIST = new LinkedList<String>();

    BlockCanaryUtils() {
    }

    public static String concernStackString(BlockInfo blockInfo) {
        String result = "";
        for (String stackEntry : blockInfo.threadStackEntries) {
            String[] lines;
            if (!Character.isLetter(stackEntry.charAt(0))) continue;
            for (String line : lines = stackEntry.split("\r\n")) {
                String keyStackString = BlockCanaryUtils.concernStackString(line);
                if (keyStackString == null) continue;
                return keyStackString;
            }
            return BlockCanaryUtils.classSimpleName(lines[0]);
        }
        return result;
    }

    public static boolean isBlockInfoValid(BlockInfo blockInfo) {
        boolean isValid = !TextUtils.isEmpty((CharSequence)blockInfo.timeStart);
        isValid = isValid && blockInfo.timeCost >= 0L;
        return isValid;
    }

    public static boolean isInWhiteList(BlockInfo info) {
        for (String stackEntry : info.threadStackEntries) {
            String[] lines;
            if (!Character.isLetter(stackEntry.charAt(0))) continue;
            for (String line : lines = stackEntry.split("\r\n")) {
                for (String whiteListEntry : WHITE_LIST) {
                    if (!line.startsWith(whiteListEntry)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<String> getConcernPackages() {
        return CONCERN_LIST;
    }

    private static String concernStackString(String line) {
        for (String concernPackage : CONCERN_LIST) {
            if (!line.startsWith(concernPackage)) continue;
            return BlockCanaryUtils.classSimpleName(line);
        }
        return null;
    }

    private static String classSimpleName(String stackLine) {
        int index1 = stackLine.indexOf(40);
        int index2 = stackLine.indexOf(41);
        if (index1 >= 0 && index2 >= 0) {
            return stackLine.substring(index1 + 1, index2);
        }
        return stackLine;
    }

    static {
        WHITE_LIST.addAll(BlockCanaryInternals.getContext().provideWhiteList());
        if (BlockCanaryInternals.getContext().concernPackages() != null) {
            CONCERN_LIST.addAll(BlockCanaryInternals.getContext().concernPackages());
        }
        if (CONCERN_LIST.isEmpty()) {
            CONCERN_LIST.add(ProcessUtils.myProcessName());
        }
    }
}

