/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.ui;

import android.util.Log;
import com.github.moduth.blockcanary.internal.BlockInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

final class BlockInfoEx
extends BlockInfo {
    private static final String TAG = "BlockInfoEx";
    public File logFile;
    public String concernStackString;

    BlockInfoEx() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockInfoEx newInstance(File file) {
        BlockInfoEx blockInfo = new BlockInfoEx();
        blockInfo.logFile = file;
        BufferedReader reader = null;
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            reader = new BufferedReader(in);
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("qua")) {
                    blockInfo.qualifier = line.split(" = ")[1];
                } else if (line.startsWith("model")) {
                    blockInfo.model = line.split(" = ")[1];
                } else if (line.startsWith("api-level")) {
                    blockInfo.apiLevel = line.split(" = ")[1];
                } else if (line.startsWith("imei")) {
                    blockInfo.imei = line.split(" = ")[1];
                } else if (line.startsWith("cpu-core")) {
                    blockInfo.cpuCoreNum = Integer.valueOf(line.split(" = ")[1]);
                } else if (line.startsWith("uid")) {
                    blockInfo.uid = line.split(" = ")[1];
                } else if (line.startsWith("time-start")) {
                    blockInfo.timeStart = line.split(" = ")[1];
                } else if (line.startsWith("time-end")) {
                    blockInfo.timeEnd = line.split(" = ")[1];
                } else if (line.startsWith("time")) {
                    blockInfo.timeCost = Long.valueOf(line.split(" = ")[1]);
                } else if (line.startsWith("thread-time")) {
                    blockInfo.threadTimeCost = Long.valueOf(line.split(" = ")[1]);
                } else if (line.startsWith("process")) {
                    blockInfo.processName = line.split(" = ")[1];
                } else if (line.startsWith("versionName")) {
                    blockInfo.versionName = line.split(" = ")[1];
                } else if (line.startsWith("versionCode")) {
                    blockInfo.versionCode = Integer.valueOf(line.split(" = ")[1]);
                } else if (line.startsWith("network")) {
                    blockInfo.network = line.split(" = ")[1];
                } else if (line.startsWith("totalMemory")) {
                    blockInfo.totalMemory = line.split(" = ")[1];
                } else if (line.startsWith("freeMemory")) {
                    blockInfo.freeMemory = line.split(" = ")[1];
                } else if (line.startsWith("cpu-busy")) {
                    blockInfo.cpuBusy = Boolean.valueOf(line.split(" = ")[1]);
                } else if (line.startsWith("cpu-rate")) {
                    String[] split = line.split(" = ");
                    if (split.length > 1) {
                        StringBuilder cpuRateSb = new StringBuilder(split[1]);
                        cpuRateSb.append(line.split(" = ")[1]).append("\r\n");
                        line = reader.readLine();
                        while (line != null && !line.equals("")) {
                            cpuRateSb.append(line).append("\r\n");
                            line = reader.readLine();
                        }
                        blockInfo.cpuRateInfo = cpuRateSb.toString();
                    }
                } else if (line.startsWith("stack")) {
                    StringBuilder stackSb = new StringBuilder(line.split(" = ")[1]);
                    line = reader.readLine();
                    while (line != null) {
                        if (!line.equals("")) {
                            stackSb.append(line).append("\r\n");
                        } else if (stackSb.length() > 0) {
                            blockInfo.threadStackEntries.add(stackSb.toString());
                            stackSb = new StringBuilder();
                        }
                        line = reader.readLine();
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            reader = null;
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"newInstance: ", (Throwable)t);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"newInstance: ", (Throwable)e);
            }
        }
        blockInfo.flushString();
        return blockInfo;
    }
}

