/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.ui;

import android.content.Context;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.github.moduth.blockcanary.R;
import com.github.moduth.blockcanary.internal.BlockInfo;
import com.github.moduth.blockcanary.ui.BlockCanaryUtils;
import com.github.moduth.blockcanary.ui.DisplayConnectorView;
import com.github.moduth.blockcanary.ui.MoreDetailsView;
import java.util.Arrays;

final class DetailAdapter
extends BaseAdapter {
    private static final int TOP_ROW = 0;
    private static final int NORMAL_ROW = 1;
    private boolean[] mFoldings = new boolean[0];
    private BlockInfo mBlockInfo;
    private static final int POSITION_BASIC = 1;
    private static final int POSITION_TIME = 2;
    private static final int POSITION_CPU = 3;
    private static final int POSITION_THREAD_STACK = 4;

    DetailAdapter() {
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Context context = parent.getContext();
        if (this.getItemViewType(position) == 0) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.block_canary_ref_top_row, parent, false);
            }
            TextView textView = (TextView)DetailAdapter.findById(convertView, R.id.__leak_canary_row_text);
            textView.setText((CharSequence)context.getPackageName());
        } else {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.block_canary_ref_row, parent, false);
            }
            TextView textView = (TextView)DetailAdapter.findById(convertView, R.id.__leak_canary_row_text);
            boolean isThreadStackEntry = position == 5;
            String element = this.getItem(position);
            String htmlString = this.elementToHtmlString(element, position, this.mFoldings[position]);
            if (isThreadStackEntry && !this.mFoldings[position]) {
                htmlString = htmlString + " <font color='#919191'>blocked</font>";
            }
            textView.setText((CharSequence)Html.fromHtml((String)htmlString));
            DisplayConnectorView connectorView = (DisplayConnectorView)((Object)DetailAdapter.findById(convertView, R.id.__leak_canary_row_connector));
            connectorView.setType(this.connectorViewType(position));
            MoreDetailsView moreDetailsView = (MoreDetailsView)((Object)DetailAdapter.findById(convertView, R.id.__leak_canary_row_more));
            moreDetailsView.setFolding(this.mFoldings[position]);
        }
        return convertView;
    }

    private DisplayConnectorView.Type connectorViewType(int position) {
        return position == 1 ? DisplayConnectorView.Type.START : (position == this.getCount() - 1 ? DisplayConnectorView.Type.END : DisplayConnectorView.Type.NODE);
    }

    private String elementToHtmlString(String element, int position, boolean folding) {
        String htmlString = element.replaceAll("\r\n", "<br>");
        switch (position) {
            case 1: {
                if (folding) {
                    htmlString = htmlString.substring(htmlString.indexOf("cpu-core"));
                }
                htmlString = String.format("<font color='#c48a47'>%s</font> ", htmlString);
                break;
            }
            case 2: {
                if (folding) {
                    htmlString = htmlString.substring(0, htmlString.indexOf("time-start"));
                }
                htmlString = String.format("<font color='#f3cf83'>%s</font> ", htmlString);
                break;
            }
            case 3: {
                htmlString = element;
                if (folding) {
                    htmlString = htmlString.substring(0, htmlString.indexOf("cpu-rate"));
                }
                htmlString = htmlString.replace("cpurate = ", "<br>cpurate<br/>");
                htmlString = String.format("<font color='#998bb5'>%s</font> ", htmlString);
                htmlString = htmlString.replaceAll("]", "]<br>");
                break;
            }
            default: {
                if (folding) {
                    for (String concernPackage : BlockCanaryUtils.getConcernPackages()) {
                        int index = htmlString.indexOf(concernPackage);
                        if (index <= 0) continue;
                        htmlString = htmlString.substring(index);
                        break;
                    }
                }
                htmlString = String.format("<font color='#ffffff'>%s</font> ", htmlString);
            }
        }
        return htmlString;
    }

    public void update(BlockInfo blockInfo) {
        if (this.mBlockInfo != null && blockInfo.timeStart.equals(this.mBlockInfo.timeStart)) {
            return;
        }
        this.mBlockInfo = blockInfo;
        this.mFoldings = new boolean[4 + this.mBlockInfo.threadStackEntries.size()];
        Arrays.fill(this.mFoldings, true);
        this.notifyDataSetChanged();
    }

    public void toggleRow(int position) {
        this.mFoldings[position] = !this.mFoldings[position];
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.mBlockInfo == null) {
            return 0;
        }
        return 4 + this.mBlockInfo.threadStackEntries.size();
    }

    public String getItem(int position) {
        if (this.getItemViewType(position) == 0) {
            return null;
        }
        switch (position) {
            case 1: {
                return this.mBlockInfo.getBasicString();
            }
            case 2: {
                return this.mBlockInfo.getTimeString();
            }
            case 3: {
                return this.mBlockInfo.getCpuString();
            }
        }
        return (String)this.mBlockInfo.threadStackEntries.get(position - 4);
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            return 0;
        }
        return 1;
    }

    public long getItemId(int position) {
        return position;
    }

    private static <T extends View> T findById(View view, int id2) {
        return (T)view.findViewById(id2);
    }
}

