/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.ui;

import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.github.moduth.blockcanary.BlockCanaryContext;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.LogWriter;
import com.github.moduth.blockcanary.R;
import com.github.moduth.blockcanary.ui.BlockCanaryUtils;
import com.github.moduth.blockcanary.ui.BlockInfoCorruptException;
import com.github.moduth.blockcanary.ui.BlockInfoEx;
import com.github.moduth.blockcanary.ui.DetailAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class DisplayActivity
extends Activity {
    private static final String TAG = "DisplayActivity";
    private static final String SHOW_BLOCK_EXTRA = "show_latest";
    public static final String SHOW_BLOCK_EXTRA_KEY = "BlockStartTime";
    private List<BlockInfoEx> mBlockInfoEntries = new ArrayList<BlockInfoEx>();
    private String mBlockStartTime;
    private ListView mListView;
    private TextView mFailureView;
    private Button mActionButton;
    private int mMaxStoredBlockCount;

    public static PendingIntent createPendingIntent(Context context, String blockStartTime) {
        Intent intent = new Intent(context, DisplayActivity.class);
        intent.putExtra(SHOW_BLOCK_EXTRA, blockStartTime);
        intent.setFlags(0x14000000);
        return PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mBlockStartTime = savedInstanceState.getString(SHOW_BLOCK_EXTRA_KEY);
        } else {
            Intent intent = this.getIntent();
            if (intent.hasExtra(SHOW_BLOCK_EXTRA)) {
                this.mBlockStartTime = intent.getStringExtra(SHOW_BLOCK_EXTRA);
            }
        }
        this.setContentView(R.layout.block_canary_display_leak);
        this.mListView = (ListView)this.findViewById(R.id.__leak_canary_display_leak_list);
        this.mFailureView = (TextView)this.findViewById(R.id.__leak_canary_display_leak_failure);
        this.mActionButton = (Button)this.findViewById(R.id.__leak_canary_action);
        this.mMaxStoredBlockCount = this.getResources().getInteger(R.integer.block_canary_max_stored_count);
        this.updateUi();
    }

    public Object onRetainNonConfigurationInstance() {
        return this.mBlockInfoEntries;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(SHOW_BLOCK_EXTRA_KEY, this.mBlockStartTime);
    }

    protected void onResume() {
        super.onResume();
        LoadBlocks.load(this);
    }

    public void setTheme(int resid) {
        if (resid != R.style.block_canary_BlockCanary_Base) {
            return;
        }
        super.setTheme(resid);
    }

    protected void onDestroy() {
        super.onDestroy();
        LoadBlocks.forgetActivity();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        final BlockInfoEx blockInfo = this.getBlock(this.mBlockStartTime);
        if (blockInfo != null) {
            menu.add(R.string.block_canary_share_leak).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DisplayActivity.this.shareBlock(blockInfo);
                    return true;
                }
            });
            menu.add(R.string.block_canary_share_stack_dump).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DisplayActivity.this.shareHeapDump(blockInfo);
                    return true;
                }
            });
            return true;
        }
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.mBlockStartTime = null;
            this.updateUi();
        }
        return true;
    }

    public void onBackPressed() {
        if (this.mBlockStartTime != null) {
            this.mBlockStartTime = null;
            this.updateUi();
        } else {
            super.onBackPressed();
        }
    }

    private void shareBlock(BlockInfoEx blockInfo) {
        String leakInfo = blockInfo.toString();
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", leakInfo);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.block_canary_share_with)));
    }

    private void shareHeapDump(BlockInfoEx blockInfo) {
        File heapDumpFile = blockInfo.logFile;
        if (Build.VERSION.SDK_INT >= 9) {
            heapDumpFile.setReadable(true, false);
        }
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("application/octet-stream");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)heapDumpFile));
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.block_canary_share_with)));
    }

    private void updateUi() {
        BlockInfoEx blockInfo = this.getBlock(this.mBlockStartTime);
        if (blockInfo == null) {
            this.mBlockStartTime = null;
        }
        this.mListView.setVisibility(0);
        this.mFailureView.setVisibility(8);
        if (blockInfo != null) {
            this.renderBlockDetail(blockInfo);
        } else {
            this.renderBlockList();
        }
    }

    private void renderBlockList() {
        ListAdapter listAdapter = this.mListView.getAdapter();
        if (listAdapter instanceof BlockListAdapter) {
            ((BlockListAdapter)listAdapter).notifyDataSetChanged();
        } else {
            BlockListAdapter adapter = new BlockListAdapter();
            this.mListView.setAdapter((ListAdapter)adapter);
            this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    DisplayActivity.this.mBlockStartTime = ((BlockInfoEx)((Object)((DisplayActivity)DisplayActivity.this).mBlockInfoEntries.get((int)position))).timeStart;
                    DisplayActivity.this.updateUi();
                }
            });
            if (Build.VERSION.SDK_INT >= 11) {
                this.invalidateOptionsMenu();
                ActionBar actionBar = this.getActionBar();
                if (actionBar != null) {
                    actionBar.setDisplayHomeAsUpEnabled(false);
                }
            }
            this.setTitle(this.getString(R.string.block_canary_block_list_title, new Object[]{this.getPackageName()}));
            this.mActionButton.setText(R.string.block_canary_delete_all);
            this.mActionButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DialogInterface.OnClickListener okListener = new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                            LogWriter.deleteAll();
                            DisplayActivity.this.mBlockInfoEntries = Collections.emptyList();
                            DisplayActivity.this.updateUi();
                        }
                    };
                    new AlertDialog.Builder((Context)DisplayActivity.this).setTitle((CharSequence)DisplayActivity.this.getString(R.string.block_canary_delete)).setMessage((CharSequence)DisplayActivity.this.getString(R.string.block_canary_delete_all_dialog_content)).setPositiveButton((CharSequence)DisplayActivity.this.getString(R.string.block_canary_yes), okListener).setNegativeButton((CharSequence)DisplayActivity.this.getString(R.string.block_canary_no), null).show();
                }
            });
        }
        this.mActionButton.setVisibility(this.mBlockInfoEntries.isEmpty() ? 8 : 0);
    }

    private void renderBlockDetail(final BlockInfoEx blockInfo) {
        DetailAdapter adapter;
        ListAdapter listAdapter = this.mListView.getAdapter();
        if (listAdapter instanceof DetailAdapter) {
            adapter = (DetailAdapter)listAdapter;
        } else {
            adapter = new DetailAdapter();
            this.mListView.setAdapter((ListAdapter)adapter);
            this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    adapter.toggleRow(position);
                }
            });
            if (Build.VERSION.SDK_INT >= 11) {
                this.invalidateOptionsMenu();
                ActionBar actionBar = this.getActionBar();
                if (actionBar != null) {
                    actionBar.setDisplayHomeAsUpEnabled(true);
                }
            }
            this.mActionButton.setVisibility(0);
            this.mActionButton.setText(R.string.block_canary_delete);
        }
        this.mActionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (blockInfo != null) {
                    blockInfo.logFile.delete();
                    DisplayActivity.this.mBlockStartTime = null;
                    DisplayActivity.this.mBlockInfoEntries.remove((Object)blockInfo);
                    DisplayActivity.this.updateUi();
                }
            }
        });
        adapter.update(blockInfo);
        this.setTitle(this.getString(R.string.block_canary_class_has_blocked, new Object[]{blockInfo.timeCost}));
    }

    private BlockInfoEx getBlock(String startTime) {
        if (this.mBlockInfoEntries == null || TextUtils.isEmpty((CharSequence)startTime)) {
            return null;
        }
        for (BlockInfoEx blockInfo : this.mBlockInfoEntries) {
            if (blockInfo.timeStart == null || !startTime.equals(blockInfo.timeStart)) continue;
            return blockInfo;
        }
        return null;
    }

    static class LoadBlocks
    implements Runnable {
        static final List<LoadBlocks> inFlight = new ArrayList<LoadBlocks>();
        static final Executor backgroundExecutor = Executors.newSingleThreadExecutor();
        private DisplayActivity activityOrNull;
        private final Handler mainHandler;

        LoadBlocks(DisplayActivity activity) {
            this.activityOrNull = activity;
            this.mainHandler = new Handler(Looper.getMainLooper());
        }

        static void load(DisplayActivity activity) {
            LoadBlocks loadBlocks = new LoadBlocks(activity);
            inFlight.add(loadBlocks);
            backgroundExecutor.execute(loadBlocks);
        }

        static void forgetActivity() {
            for (LoadBlocks loadBlocks : inFlight) {
                loadBlocks.activityOrNull = null;
            }
            inFlight.clear();
        }

        @Override
        public void run() {
            final ArrayList<BlockInfoEx> blockInfoList = new ArrayList<BlockInfoEx>();
            File[] files = BlockCanaryInternals.getLogFiles();
            if (files != null) {
                for (File blockFile : files) {
                    try {
                        BlockInfoEx blockInfo = BlockInfoEx.newInstance(blockFile);
                        if (!BlockCanaryUtils.isBlockInfoValid(blockInfo)) {
                            throw new BlockInfoCorruptException(blockInfo);
                        }
                        boolean needAddToList = true;
                        if (BlockCanaryUtils.isInWhiteList(blockInfo)) {
                            if (BlockCanaryContext.get().deleteFilesInWhiteList()) {
                                blockFile.delete();
                                blockFile = null;
                            }
                            needAddToList = false;
                        }
                        blockInfo.concernStackString = BlockCanaryUtils.concernStackString(blockInfo);
                        if (BlockCanaryContext.get().filterNonConcernStack() && TextUtils.isEmpty((CharSequence)blockInfo.concernStackString)) {
                            needAddToList = false;
                        }
                        if (!needAddToList || blockFile == null) continue;
                        blockInfoList.add(blockInfo);
                    }
                    catch (Exception e) {
                        blockFile.delete();
                        Log.e((String)DisplayActivity.TAG, (String)("Could not read block log file, deleted :" + blockFile), (Throwable)e);
                    }
                }
                Collections.sort(blockInfoList, new Comparator<BlockInfoEx>(){

                    @Override
                    public int compare(BlockInfoEx lhs, BlockInfoEx rhs) {
                        return Long.valueOf(rhs.logFile.lastModified()).compareTo(lhs.logFile.lastModified());
                    }
                });
            }
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    inFlight.remove(LoadBlocks.this);
                    if (LoadBlocks.this.activityOrNull != null) {
                        LoadBlocks.this.activityOrNull.mBlockInfoEntries = blockInfoList;
                        Log.d((String)DisplayActivity.TAG, (String)("load block entries: " + blockInfoList.size()));
                        LoadBlocks.this.activityOrNull.updateUi();
                    }
                }
            });
        }
    }

    class BlockListAdapter
    extends BaseAdapter {
        BlockListAdapter() {
        }

        public int getCount() {
            return DisplayActivity.this.mBlockInfoEntries.size();
        }

        public BlockInfoEx getItem(int position) {
            return (BlockInfoEx)((Object)DisplayActivity.this.mBlockInfoEntries.get(position));
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)DisplayActivity.this).inflate(R.layout.block_canary_block_row, parent, false);
            }
            TextView titleView = (TextView)convertView.findViewById(R.id.__leak_canary_row_text);
            TextView timeView = (TextView)convertView.findViewById(R.id.__leak_canary_row_time);
            BlockInfoEx blockInfo = this.getItem(position);
            String index = position == 0 && DisplayActivity.this.mBlockInfoEntries.size() == DisplayActivity.this.mMaxStoredBlockCount ? "MAX. " : DisplayActivity.this.mBlockInfoEntries.size() - position + ". ";
            String keyStackString = BlockCanaryUtils.concernStackString(blockInfo);
            String title = index + keyStackString + " " + DisplayActivity.this.getString(R.string.block_canary_class_has_blocked, new Object[]{blockInfo.timeCost});
            titleView.setText((CharSequence)title);
            String time = DateUtils.formatDateTime((Context)DisplayActivity.this, (long)blockInfo.logFile.lastModified(), (int)17);
            timeView.setText((CharSequence)time);
            return convertView;
        }
    }
}

