/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.github.moduth.blockcanary.ui.BlockCanaryUi;

public final class MoreDetailsView
extends View {
    private final Paint mIconPaint = new Paint(1);
    private boolean mFolding = true;

    public MoreDetailsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mIconPaint.setStrokeWidth(BlockCanaryUi.dpToPixel(2.0f, this.getResources()));
        this.mIconPaint.setColor(-8083771);
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int halfHeight = height / 2;
        int halfWidth = width / 2;
        canvas.drawLine(0.0f, (float)halfHeight, (float)width, (float)halfHeight, this.mIconPaint);
        if (this.mFolding) {
            canvas.drawLine((float)halfWidth, 0.0f, (float)halfWidth, (float)height, this.mIconPaint);
        }
    }

    public void setFolding(boolean folding) {
        if (folding != this.mFolding) {
            this.mFolding = folding;
            this.invalidate();
        }
    }
}

