/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog;

import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.SyslogParser;
import com.github.palindromicity.syslog.util.Validate;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

abstract class AbstractSyslogParser
implements SyslogParser {
    private KeyProvider keyProvider;
    private EnumSet<AllowableDeviations> deviations;
    private NilPolicy nilPolicy = NilPolicy.OMIT;
    private StructuredDataPolicy structuredDataPolicy = StructuredDataPolicy.FLATTEN;

    AbstractSyslogParser(KeyProvider keyProvider, EnumSet<AllowableDeviations> deviations) {
        Validate.notNull(keyProvider, "keyProvider");
        this.keyProvider = keyProvider;
        this.deviations = deviations;
    }

    AbstractSyslogParser(KeyProvider keyProvider, EnumSet<AllowableDeviations> deviations, NilPolicy nilPolicy, StructuredDataPolicy structuredDataPolicy) {
        Validate.notNull(keyProvider, "keyProvider");
        this.keyProvider = keyProvider;
        this.deviations = deviations;
        if (nilPolicy != null) {
            this.nilPolicy = nilPolicy;
        }
        if (structuredDataPolicy != null) {
            this.structuredDataPolicy = structuredDataPolicy;
        }
    }

    KeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    EnumSet<AllowableDeviations> getDeviations() {
        return this.deviations;
    }

    NilPolicy getNilPolicy() {
        return this.nilPolicy;
    }

    StructuredDataPolicy getStructuredDataPolicy() {
        return this.structuredDataPolicy;
    }

    @Override
    public abstract Map<String, Object> parseLine(String var1);

    @Override
    public void parseLine(String line, Consumer<Map<String, Object>> consumer) {
        Validate.notNull(consumer, "consumer");
        consumer.accept(this.parseLine(line));
    }

    @Override
    public List<Map<String, Object>> parseLines(Reader reader) {
        Validate.notNull(reader, "reader");
        return new BufferedReader(reader).lines().map(this::parseLine).collect(Collectors.toList());
    }

    @Override
    public void parseLines(Reader reader, Consumer<Map<String, Object>> consumer) {
        Validate.notNull(reader, "reader");
        Validate.notNull(consumer, "consumer");
        new BufferedReader(reader).lines().map(this::parseLine).forEach(consumer);
    }

    @Override
    public void parseLines(Reader reader, Consumer<Map<String, Object>> messageConsumer, BiConsumer<String, Throwable> errorConsumer) {
        Validate.notNull(reader, "reader");
        Validate.notNull(reader, "messageConsumer");
        Validate.notNull(reader, "errorConsumer");
        List<String> lines = new BufferedReader(reader).lines().collect(Collectors.toList());
        lines.forEach(line -> {
            try {
                messageConsumer.accept(this.parseLine((String)line));
            }
            catch (Throwable throwable) {
                errorConsumer.accept((String)line, throwable);
            }
        });
    }
}

