/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog;

import com.github.palindromicity.syslog.AbstractSyslogParser;
import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.dsl.DefaultErrorListener;
import com.github.palindromicity.syslog.dsl.Syslog5424Listener;
import com.github.palindromicity.syslog.dsl.generated.Rfc5424Lexer;
import com.github.palindromicity.syslog.dsl.generated.Rfc5424Parser;
import com.github.palindromicity.syslog.util.Validate;
import java.util.EnumSet;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

class Rfc5424SyslogParser
extends AbstractSyslogParser {
    Rfc5424SyslogParser(KeyProvider keyProvider) {
        this(keyProvider, null, null, EnumSet.of(AllowableDeviations.NONE));
    }

    Rfc5424SyslogParser(KeyProvider keyProvider, NilPolicy nilPolicy, StructuredDataPolicy structuredDataPolicy) {
        this(keyProvider, nilPolicy, structuredDataPolicy, EnumSet.of(AllowableDeviations.NONE));
    }

    Rfc5424SyslogParser(KeyProvider keyProvider, NilPolicy nilPolicy, StructuredDataPolicy structuredDataPolicy, EnumSet<AllowableDeviations> deviations) {
        super(keyProvider, deviations, nilPolicy, structuredDataPolicy);
    }

    @Override
    public Map<String, Object> parseLine(String syslogLine) {
        Validate.notBlank(syslogLine, "syslogLine");
        Rfc5424Lexer lexer = new Rfc5424Lexer((CharStream)new ANTLRInputStream(syslogLine));
        lexer.removeErrorListeners();
        lexer.addErrorListener(new DefaultErrorListener());
        Rfc5424Parser parser = new Rfc5424Parser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        Syslog5424Listener listener = new Syslog5424Listener(this.getKeyProvider(), this.getNilPolicy(), this.getStructuredDataPolicy(), this.getDeviations());
        parser.addParseListener(listener);
        parser.removeErrorListeners();
        parser.addErrorListener(new DefaultErrorListener());
        parser.syslog_msg();
        return listener.getMessageMap();
    }
}

