/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.AutoLoadHandler;
import com.jarvis.cache.CacheUtil;
import com.jarvis.cache.DataLoader;
import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.RefreshHandler;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.annotation.CacheDelete;
import com.jarvis.cache.annotation.CacheDeleteKey;
import com.jarvis.cache.annotation.ExCache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.aop.DeleteCacheAopProxyChain;
import com.jarvis.cache.clone.ICloner;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.cache.to.ProcessingTO;
import com.jarvis.cache.type.CacheOpType;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class AbstractCacheManager
implements ICacheManager {
    private static final Logger logger = Logger.getLogger(AbstractCacheManager.class);
    public final ConcurrentHashMap<CacheKeyTO, ProcessingTO> processing = new ConcurrentHashMap();
    private final AutoLoadHandler autoLoadHandler;
    private String namespace;
    private final ISerializer<Object> serializer;
    private final AbstractScriptParser scriptParser;
    private final RefreshHandler refreshHandler;
    private ICloner cloner;

    public AbstractCacheManager(AutoLoadConfig config, ISerializer<Object> serializer, AbstractScriptParser scriptParser) {
        this.autoLoadHandler = new AutoLoadHandler(this, config);
        this.cloner = this.serializer = serializer;
        this.scriptParser = scriptParser;
        this.registerFunction(config.getFunctions());
        this.refreshHandler = new RefreshHandler(this, config);
    }

    public Object proceed(CacheAopProxyChain pjp, Cache cache) throws Throwable {
        Object[] arguments = pjp.getArgs();
        if (null != cache.opType() && cache.opType() == CacheOpType.WRITE) {
            DataLoader dataLoader = new DataLoader(pjp, cache, this);
            Object result = dataLoader.getData();
            CacheWrapper<Object> cacheWrapper = dataLoader.buildCacheWrapper(result).getCacheWrapper();
            if (this.scriptParser.isCacheable(cache, arguments, result)) {
                CacheKeyTO cacheKey = this.getCacheKey(pjp, cache, result);
                AutoLoadTO autoLoadTO = this.autoLoadHandler.getAutoLoadTO(cacheKey);
                try {
                    this.writeCache(pjp, pjp.getArgs(), cache, cacheKey, cacheWrapper);
                    if (null != autoLoadTO) {
                        autoLoadTO.setLastLoadTime(cacheWrapper.getLastLoadTime()).setExpire(cacheWrapper.getExpire());
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            return result;
        }
        if (!this.scriptParser.isCacheable(cache, arguments)) {
            return this.getData(pjp);
        }
        CacheKeyTO cacheKey = this.getCacheKey(pjp, cache);
        if (null == cacheKey) {
            return this.getData(pjp);
        }
        Method method = pjp.getMethod();
        CacheWrapper<Object> cacheWrapper = null;
        try {
            cacheWrapper = this.get(cacheKey, method, arguments);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (null != cacheWrapper && !cacheWrapper.isExpired()) {
            AutoLoadTO autoLoadTO = this.autoLoadHandler.putIfAbsent(cacheKey, pjp, cache, cacheWrapper);
            if (null != autoLoadTO) {
                autoLoadTO.setLastRequestTime(System.currentTimeMillis()).setLastLoadTime(cacheWrapper.getLastLoadTime()).setExpire(cacheWrapper.getExpire());
            } else {
                this.refreshHandler.doRefresh(pjp, cache, cacheKey, cacheWrapper);
            }
            return cacheWrapper.getCacheObject();
        }
        DataLoader dataLoader = new DataLoader(pjp, cacheKey, cache, this);
        CacheWrapper<Object> newCacheWrapper = dataLoader.loadData().getCacheWrapper();
        AutoLoadTO autoLoadTO = null;
        if (dataLoader.isFirst()) {
            autoLoadTO = this.autoLoadHandler.putIfAbsent(cacheKey, pjp, cache, newCacheWrapper);
            try {
                this.writeCache(pjp, pjp.getArgs(), cache, cacheKey, newCacheWrapper);
                if (null != autoLoadTO) {
                    autoLoadTO.setLastRequestTime(System.currentTimeMillis()).setLastLoadTime(newCacheWrapper.getLastLoadTime()).setExpire(newCacheWrapper.getExpire()).addUseTotalTime(dataLoader.getLoadDataUseTime());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return newCacheWrapper.getCacheObject();
    }

    public void deleteCache(DeleteCacheAopProxyChain jp, CacheDelete cacheDelete, Object retVal) {
        Object[] arguments = jp.getArgs();
        CacheDeleteKey[] keys = cacheDelete.value();
        if (null == keys || keys.length == 0) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            CacheDeleteKey keyConfig = keys[i];
            try {
                CacheKeyTO key;
                if (!this.scriptParser.isCanDelete(keyConfig, arguments, retVal) || null == (key = this.getCacheKey(jp, keyConfig, retVal))) continue;
                this.delete(key);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Object getData(CacheAopProxyChain pjp) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object[] arguments = pjp.getArgs();
        Object result = pjp.doProxyChain(arguments);
        long useTime = System.currentTimeMillis() - startTime;
        AutoLoadConfig config = this.autoLoadHandler.getConfig();
        if (config.isPrintSlowLog() && useTime >= (long)config.getSlowLoadTime()) {
            String className = pjp.getTargetClass().getName();
            logger.error((Object)(className + "." + pjp.getMethod().getName() + ", use time:" + useTime + "ms"));
        }
        return result;
    }

    public void writeCache(CacheAopProxyChain pjp, Object[] arguments, Cache cache, CacheKeyTO cacheKey, CacheWrapper<Object> cacheWrapper) throws Exception {
        if (null == cacheKey) {
            return;
        }
        Method method = pjp.getMethod();
        this.setCache(cacheKey, cacheWrapper, method, arguments);
        ExCache[] exCaches = cache.exCache();
        if (null == exCaches || exCaches.length == 0) {
            return;
        }
        Object result = cacheWrapper.getCacheObject();
        for (ExCache exCache : exCaches) {
            try {
                CacheKeyTO exCacheKey;
                if (!this.scriptParser.isCacheable(exCache, arguments, result) || null == (exCacheKey = this.getCacheKey(pjp, arguments, exCache, result))) continue;
                Object exResult = null;
                exResult = null == exCache.cacheObject() || exCache.cacheObject().length() == 0 ? result : this.scriptParser.getElValue(exCache.cacheObject(), arguments, result, true, Object.class);
                int exCacheExpire = this.scriptParser.getRealExpire(exCache.expire(), exCache.expireExpression(), arguments, exResult);
                CacheWrapper<Object> exCacheWrapper = new CacheWrapper<Object>(exResult, exCacheExpire);
                AutoLoadTO tmpAutoLoadTO = this.autoLoadHandler.getAutoLoadTO(exCacheKey);
                this.setCache(exCacheKey, exCacheWrapper, method, arguments);
                if (null == tmpAutoLoadTO) continue;
                tmpAutoLoadTO.setExpire(exCacheExpire).setLastLoadTime(exCacheWrapper.getLastLoadTime());
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void destroy() {
        this.autoLoadHandler.shutdown();
        this.refreshHandler.shutdown();
        logger.info((Object)"cache destroy ... ... ...");
    }

    private CacheKeyTO getCacheKey(String className, String methodName, Object[] arguments, String _key, String _hfield, Object result, boolean hasRetVal) {
        String key = null;
        String hfield = null;
        if (null != _key && _key.trim().length() > 0) {
            try {
                key = this.scriptParser.getDefinedCacheKey(_key, arguments, result, hasRetVal);
                if (null != _hfield && _hfield.trim().length() > 0) {
                    hfield = this.scriptParser.getDefinedCacheKey(_hfield, arguments, result, hasRetVal);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            key = CacheUtil.getDefaultCacheKey(className, methodName, arguments);
        }
        if (null == key || key.trim().length() == 0) {
            logger.error((Object)(className + "." + methodName + "; cache key is empty"));
            return null;
        }
        return new CacheKeyTO(this.namespace, key, hfield);
    }

    private CacheKeyTO getCacheKey(CacheAopProxyChain pjp, Cache cache) {
        String className = pjp.getTargetClass().getName();
        String methodName = pjp.getMethod().getName();
        Object[] arguments = pjp.getArgs();
        String _key = cache.key();
        String _hfield = cache.hfield();
        return this.getCacheKey(className, methodName, arguments, _key, _hfield, null, false);
    }

    private CacheKeyTO getCacheKey(CacheAopProxyChain pjp, Cache cache, Object result) {
        String className = pjp.getTargetClass().getName();
        String methodName = pjp.getMethod().getName();
        Object[] arguments = pjp.getArgs();
        String _key = cache.key();
        String _hfield = cache.hfield();
        return this.getCacheKey(className, methodName, arguments, _key, _hfield, result, true);
    }

    private CacheKeyTO getCacheKey(CacheAopProxyChain pjp, Object[] arguments, ExCache exCache, Object result) {
        String className = pjp.getTargetClass().getName();
        String methodName = pjp.getMethod().getName();
        String _key = exCache.key();
        if (null == _key || _key.trim().length() == 0) {
            return null;
        }
        String _hfield = exCache.hfield();
        return this.getCacheKey(className, methodName, arguments, _key, _hfield, result, true);
    }

    private CacheKeyTO getCacheKey(DeleteCacheAopProxyChain jp, CacheDeleteKey cacheDeleteKey, Object retVal) {
        String className = jp.getTargetClass().getName();
        String methodName = jp.getMethod().getName();
        Object[] arguments = jp.getArgs();
        String _key = cacheDeleteKey.value();
        String _hfield = cacheDeleteKey.hfield();
        return this.getCacheKey(className, methodName, arguments, _key, _hfield, retVal, true);
    }

    public ISerializer<Object> getSerializer() {
        return this.serializer;
    }

    public AutoLoadHandler getAutoLoadHandler() {
        return this.autoLoadHandler;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public AbstractScriptParser getScriptParser() {
        return this.scriptParser;
    }

    public ICloner getCloner() {
        return this.cloner;
    }

    public void setCloner(ICloner cloner) {
        this.cloner = cloner;
    }

    private void registerFunction(Map<String, String> funcs) {
        if (null == this.scriptParser) {
            return;
        }
        if (null == funcs || funcs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : funcs.entrySet()) {
            try {
                String name = entry.getKey();
                Class<?> cls = Class.forName(entry.getValue());
                Method method = cls.getDeclaredMethod(name, Object.class);
                this.scriptParser.addFunction(name, method);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

