/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.AbstractCacheManager;
import com.jarvis.cache.DataLoader;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class AutoLoadHandler {
    private static final Logger logger = Logger.getLogger(AutoLoadHandler.class);
    public static final Integer AUTO_LOAD_MIN_EXPIRE = 120;
    private final ConcurrentHashMap<CacheKeyTO, AutoLoadTO> autoLoadMap;
    private final AbstractCacheManager cacheManager;
    private final Thread[] threads;
    private final Thread sortThread;
    private final LinkedBlockingQueue<AutoLoadTO> autoLoadQueue;
    private volatile boolean running = false;
    private final AutoLoadConfig config;
    private static final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };

    public AutoLoadHandler(AbstractCacheManager cacheManager, AutoLoadConfig config) {
        this.cacheManager = cacheManager;
        this.config = config;
        this.running = true;
        this.threads = new Thread[this.config.getThreadCnt()];
        this.autoLoadMap = new ConcurrentHashMap(this.config.getMaxElement());
        this.autoLoadQueue = new LinkedBlockingQueue(this.config.getMaxElement());
        this.sortThread = new Thread(new SortRunnable());
        this.sortThread.setDaemon(true);
        this.sortThread.start();
        for (int i = 0; i < this.config.getThreadCnt(); ++i) {
            this.threads[i] = new Thread(new AutoLoadRunnable());
            this.threads[i].setName("autoLoadThread-" + i);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
    }

    public AutoLoadConfig getConfig() {
        return this.config;
    }

    public int getSize() {
        if (null != this.autoLoadMap) {
            return this.autoLoadMap.size();
        }
        return -1;
    }

    public AutoLoadTO getAutoLoadTO(CacheKeyTO cacheKey) {
        if (null == this.autoLoadMap) {
            return null;
        }
        return this.autoLoadMap.get(cacheKey);
    }

    public void removeAutoLoadTO(CacheKeyTO cacheKey) {
        if (null == this.autoLoadMap) {
            return;
        }
        this.autoLoadMap.remove(cacheKey);
    }

    public void resetAutoLoadLastLoadTime(CacheKeyTO cacheKey) {
        AutoLoadTO autoLoadTO = this.autoLoadMap.get(cacheKey);
        if (null != autoLoadTO && !autoLoadTO.isLoading()) {
            autoLoadTO.setLastLoadTime(1L);
        }
    }

    public void shutdown() {
        this.running = false;
        this.autoLoadMap.clear();
        logger.info((Object)"----------------------AutoLoadHandler.shutdown--------------------");
    }

    public AutoLoadTO putIfAbsent(CacheKeyTO cacheKey, CacheAopProxyChain joinPoint, Cache cache, CacheWrapper<Object> cacheWrapper) {
        if (null == this.autoLoadMap) {
            return null;
        }
        AutoLoadTO autoLoadTO = this.autoLoadMap.get(cacheKey);
        if (null != autoLoadTO) {
            return autoLoadTO;
        }
        try {
            if (!this.cacheManager.getScriptParser().isAutoload(cache, joinPoint.getArgs(), cacheWrapper.getCacheObject())) {
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int expire = cacheWrapper.getExpire();
        if (cacheWrapper.getExpire() >= AUTO_LOAD_MIN_EXPIRE && this.autoLoadMap.size() <= this.config.getMaxElement()) {
            Object[] arguments = joinPoint.getArgs();
            try {
                arguments = this.cacheManager.getCloner().deepCloneMethodArgs(joinPoint.getMethod(), arguments);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            autoLoadTO = new AutoLoadTO(cacheKey, joinPoint, arguments, cache, expire);
            AutoLoadTO tmp = this.autoLoadMap.putIfAbsent(cacheKey, autoLoadTO);
            if (null == tmp) {
                return autoLoadTO;
            }
            return tmp;
        }
        return null;
    }

    public AutoLoadTO[] getAutoLoadQueue() {
        if (null == this.autoLoadMap || this.autoLoadMap.isEmpty()) {
            return null;
        }
        AutoLoadTO[] tmpArr = new AutoLoadTO[this.autoLoadMap.size()];
        tmpArr = this.autoLoadMap.values().toArray(tmpArr);
        if (null != this.config.getSortType() && null != this.config.getSortType().getComparator()) {
            Arrays.sort(tmpArr, this.config.getSortType().getComparator());
        }
        return tmpArr;
    }

    class AutoLoadRunnable
    implements Runnable {
        AutoLoadRunnable() {
        }

        @Override
        public void run() {
            while (AutoLoadHandler.this.running) {
                try {
                    AutoLoadTO tmpTO = (AutoLoadTO)AutoLoadHandler.this.autoLoadQueue.take();
                    if (null == tmpTO) continue;
                    this.loadCache(tmpTO);
                    Thread.sleep(AutoLoadHandler.this.config.getAutoLoadPeriod());
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }

        private void loadCache(AutoLoadTO autoLoadTO) {
            long oneHourSecs;
            if (null == autoLoadTO) {
                return;
            }
            long now = System.currentTimeMillis();
            if (autoLoadTO.getLastRequestTime() <= 0L || autoLoadTO.getLastLoadTime() <= 0L) {
                return;
            }
            Cache cache = autoLoadTO.getCache();
            long requestTimeout = cache.requestTimeout();
            if (requestTimeout > 0L && now - autoLoadTO.getLastRequestTime() >= requestTimeout * 1000L) {
                AutoLoadHandler.this.autoLoadMap.remove(autoLoadTO.getCacheKey());
                return;
            }
            if (autoLoadTO.getLoadCnt() > 100L && autoLoadTO.getAverageUseTime() < 10L) {
                AutoLoadHandler.this.autoLoadMap.remove(autoLoadTO.getCacheKey());
                return;
            }
            long difFirstRequestTime = now - autoLoadTO.getFirstRequestTime();
            if (difFirstRequestTime > (oneHourSecs = 3600000L) && autoLoadTO.getAverageUseTime() < 1000L && autoLoadTO.getRequestTimes() / (difFirstRequestTime / oneHourSecs) < 60L) {
                AutoLoadHandler.this.autoLoadMap.remove(autoLoadTO.getCacheKey());
                return;
            }
            if (autoLoadTO.isLoading()) {
                return;
            }
            int expire = autoLoadTO.getExpire();
            if (expire < AUTO_LOAD_MIN_EXPIRE) {
                return;
            }
            int alarmTime = autoLoadTO.getCache().alarmTime();
            long timeout = alarmTime > 0 && alarmTime < expire ? (long)(expire - alarmTime) : (expire >= 600 ? (long)(expire - 120) : (long)(expire - 60));
            int rand = ((Random)random.get()).nextInt(10);
            timeout = (timeout + (long)(rand % 2 == 0 ? rand : -rand)) * 1000L;
            if (now - autoLoadTO.getLastLoadTime() < timeout) {
                return;
            }
            CacheWrapper<Object> result = null;
            if (AutoLoadHandler.this.config.isCheckFromCacheBeforeLoad()) {
                try {
                    Method method = autoLoadTO.getJoinPoint().getMethod();
                    result = AutoLoadHandler.this.cacheManager.get(autoLoadTO.getCacheKey(), method, autoLoadTO.getArgs());
                }
                catch (Exception method) {
                    // empty catch block
                }
                if (null != result) {
                    autoLoadTO.setExpire(result.getExpire());
                    if (result.getLastLoadTime() > autoLoadTO.getLastLoadTime() && now - result.getLastLoadTime() < timeout) {
                        autoLoadTO.setLastLoadTime(result.getLastLoadTime());
                        return;
                    }
                }
            }
            CacheAopProxyChain pjp = autoLoadTO.getJoinPoint();
            CacheKeyTO cacheKey = autoLoadTO.getCacheKey();
            DataLoader dataLoader = new DataLoader(pjp, autoLoadTO, cacheKey, cache, AutoLoadHandler.this.cacheManager);
            CacheWrapper<Object> newCacheWrapper = null;
            try {
                newCacheWrapper = dataLoader.loadData().getCacheWrapper();
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
            if (dataLoader.isFirst() || null == newCacheWrapper) {
                if (null == newCacheWrapper && null != result) {
                    int newExpire = AUTO_LOAD_MIN_EXPIRE + 60;
                    newCacheWrapper = new CacheWrapper<Object>(result.getCacheObject(), newExpire);
                }
                try {
                    if (null != newCacheWrapper) {
                        AutoLoadHandler.this.cacheManager.writeCache(pjp, autoLoadTO.getArgs(), cache, cacheKey, newCacheWrapper);
                        autoLoadTO.setLastLoadTime(newCacheWrapper.getLastLoadTime()).setExpire(newCacheWrapper.getExpire()).addUseTotalTime(dataLoader.getLoadDataUseTime());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    class SortRunnable
    implements Runnable {
        SortRunnable() {
        }

        @Override
        public void run() {
            while (AutoLoadHandler.this.running) {
                AutoLoadTO[] tmpArr;
                int sleep = 100;
                if (AutoLoadHandler.this.autoLoadMap.isEmpty() || AutoLoadHandler.this.autoLoadQueue.size() > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (AutoLoadHandler.this.autoLoadMap.size() <= AutoLoadHandler.this.threads.length * 10) {
                    sleep = 1000;
                } else if (AutoLoadHandler.this.autoLoadMap.size() <= AutoLoadHandler.this.threads.length * 50) {
                    sleep = 300;
                }
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (null == (tmpArr = AutoLoadHandler.this.getAutoLoadQueue()) || tmpArr.length == 0) continue;
                for (int i = 0; i < tmpArr.length; ++i) {
                    try {
                        AutoLoadTO to = tmpArr[i];
                        AutoLoadHandler.this.autoLoadQueue.put(to);
                        if (i <= 0 || i % 2000 != 0) continue;
                        Thread.sleep(0L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

