/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.lib.util.BeanUtil;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class CacheUtil {
    private static final String SPLIT_STR = "_";

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof String) {
            return ((String)obj).length() == 0;
        }
        Class<?> cl = obj.getClass();
        if (cl.isArray()) {
            int len = Array.getLength(obj);
            return len == 0;
        }
        if (obj instanceof Collection) {
            Collection tempCol = (Collection)obj;
            return tempCol.isEmpty();
        }
        if (obj instanceof Map) {
            Map tempMap = (Map)obj;
            return tempMap.isEmpty();
        }
        return false;
    }

    private static int getHashCode(String buf) {
        int hash = 5381;
        int len = buf.length();
        while (len-- > 0) {
            hash = (hash << 5) + hash + buf.charAt(len);
        }
        return hash;
    }

    public static String getUniqueHashStr(Object obj) {
        return CacheUtil.getMiscHashCode(BeanUtil.toString(obj));
    }

    public static String getMiscHashCode(String str) {
        if (null == str || str.length() == 0) {
            return "";
        }
        if (str.length() <= 20) {
            return str;
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(str.hashCode()).append(SPLIT_STR).append(CacheUtil.getHashCode(str));
        int mid = str.length() / 2;
        String str1 = str.substring(0, mid);
        String str2 = str.substring(mid);
        tmp.append(SPLIT_STR).append(str1.hashCode());
        tmp.append(SPLIT_STR).append(str2.hashCode());
        return tmp.toString();
    }

    public static String getDefaultCacheKey(String className, String method, Object[] arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheUtil.getDefaultCacheKeyPrefix(className, method, arguments));
        if (null != arguments && arguments.length > 0) {
            sb.append(CacheUtil.getUniqueHashStr(arguments));
        }
        return sb.toString();
    }

    public static String getDefaultCacheKeyPrefix(String className, String method, Object[] arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        if (null != method && method.length() > 0) {
            sb.append(".").append(method);
        }
        return sb.toString();
    }
}

