/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.AbstractCacheManager;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.cache.to.ProcessingTO;
import org.apache.log4j.Logger;

public class DataLoader {
    private static final Logger logger = Logger.getLogger(DataLoader.class);
    private final AbstractCacheManager cacheManager;
    private final CacheAopProxyChain pjp;
    private final CacheKeyTO cacheKey;
    private final Cache cache;
    private final Object[] arguments;
    private final AutoLoadTO autoLoadTO;
    private boolean isFirst = true;
    private long loadDataUseTime;
    private CacheWrapper<Object> cacheWrapper;

    public DataLoader(CacheAopProxyChain pjp, AutoLoadTO autoLoadTO, CacheKeyTO cacheKey, Cache cache, AbstractCacheManager cacheManager) {
        this.pjp = pjp;
        this.autoLoadTO = autoLoadTO;
        this.cacheKey = cacheKey;
        this.cache = cache;
        this.cacheManager = cacheManager;
        this.arguments = null == autoLoadTO ? pjp.getArgs() : autoLoadTO.getArgs();
    }

    public DataLoader(CacheAopProxyChain pjp, CacheKeyTO cacheKey, Cache cache, AbstractCacheManager cacheManager, Object[] arguments) {
        this.pjp = pjp;
        this.cacheKey = cacheKey;
        this.cache = cache;
        this.cacheManager = cacheManager;
        this.arguments = arguments;
        this.autoLoadTO = null;
    }

    public DataLoader(CacheAopProxyChain pjp, Cache cache, AbstractCacheManager cacheManager) {
        this(pjp, null, null, cache, cacheManager);
    }

    public DataLoader(CacheAopProxyChain pjp, CacheKeyTO cacheKey, Cache cache, AbstractCacheManager cacheManager) {
        this(pjp, null, cacheKey, cache, cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader loadData() throws Throwable {
        Object result;
        ProcessingTO _isProcessing;
        ProcessingTO isProcessing = this.cacheManager.processing.get(this.cacheKey);
        ProcessingTO processingTO = null;
        if (null == isProcessing && null != (_isProcessing = this.cacheManager.processing.putIfAbsent(this.cacheKey, processingTO = new ProcessingTO()))) {
            isProcessing = _isProcessing;
        }
        ProcessingTO lock = null;
        String tname = Thread.currentThread().getName();
        if (null == isProcessing) {
            Object result2;
            this.isFirst = true;
            lock = processingTO;
            try {
                logger.debug((Object)(tname + " first thread!"));
                result2 = this.getData();
                this.buildCacheWrapper(result2);
                processingTO.setCache(this.cacheWrapper);
            }
            catch (Throwable e) {
                processingTO.setError(e);
                throw e;
            }
            finally {
                processingTO.setFirstFinished(true);
                this.cacheManager.processing.remove(this.cacheKey);
                result2 = lock;
                synchronized (result2) {
                    lock.notifyAll();
                }
            }
        }
        this.isFirst = false;
        lock = isProcessing;
        long startWait = isProcessing.getStartTime();
        while (null != isProcessing) {
            Object _cacheWrapper;
            if (isProcessing.isFirstFinished()) {
                _cacheWrapper = isProcessing.getCache();
                logger.debug((Object)(tname + " do FirstFinished" + " is null :" + (null == _cacheWrapper)));
                if (null != _cacheWrapper) {
                    this.cacheWrapper = _cacheWrapper;
                    return this;
                }
                Throwable error = isProcessing.getError();
                if (null == error) break;
                logger.debug((Object)(tname + " do error"));
                throw error;
            }
            _cacheWrapper = lock;
            synchronized (_cacheWrapper) {
                logger.debug((Object)(tname + " do wait"));
                try {
                    lock.wait(50L);
                }
                catch (InterruptedException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (System.currentTimeMillis() - startWait < (long)this.cache.waitTimeOut()) continue;
        }
        if (null == this.cacheWrapper) {
            this.cacheWrapper = this.cacheManager.get(this.cacheKey, this.pjp.getMethod(), this.arguments);
        }
        try {
            if (null == this.cacheWrapper) {
                result = this.getData();
                this.buildCacheWrapper(result);
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            result = lock;
            synchronized (result) {
                lock.notifyAll();
            }
        }
        return this;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public Object getData() throws Throwable {
        try {
            if (null != this.autoLoadTO) {
                this.autoLoadTO.setLoading(true);
            }
            long loadDataStartTime = System.currentTimeMillis();
            Object result = this.pjp.doProxyChain(this.arguments);
            this.loadDataUseTime = System.currentTimeMillis() - loadDataStartTime;
            AutoLoadConfig config = this.cacheManager.getAutoLoadHandler().getConfig();
            if (config.isPrintSlowLog() && this.loadDataUseTime >= (long)config.getSlowLoadTime()) {
                String className = this.pjp.getTargetClass().getName();
                logger.error((Object)(className + "." + this.pjp.getMethod().getName() + ", use time:" + this.loadDataUseTime + "ms"));
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (null != this.autoLoadTO) {
                this.autoLoadTO.setLoading(false);
            }
        }
    }

    public DataLoader buildCacheWrapper(Object result) {
        int expire = this.cache.expire();
        try {
            expire = this.cacheManager.getScriptParser().getRealExpire(this.cache.expire(), this.cache.expireExpression(), this.arguments, result);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.cacheWrapper = new CacheWrapper<Object>(result, expire);
        return this;
    }

    public CacheWrapper<Object> getCacheWrapper() {
        if (null == this.cacheWrapper) {
            throw new RuntimeException("run loadData() or buildCacheWrapper() please!");
        }
        return this.cacheWrapper;
    }

    public long getLoadDataUseTime() {
        return this.loadDataUseTime;
    }
}

