/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.AbstractCacheManager;
import com.jarvis.cache.DataLoader;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class RefreshHandler {
    private static final Logger logger = Logger.getLogger(RefreshHandler.class);
    private final ThreadPoolExecutor refreshThreadPool;
    private final ConcurrentHashMap<CacheKeyTO, Byte> refreshing;
    private final AbstractCacheManager cacheManager;

    public RefreshHandler(AbstractCacheManager cacheManager, AutoLoadConfig config) {
        this.cacheManager = cacheManager;
        int corePoolSize = config.getRefreshThreadPoolSize();
        int maximumPoolSize = config.getRefreshThreadPoolMaxSize();
        int keepAliveTime = config.getRefreshThreadPoolkeepAliveTime();
        TimeUnit unit = TimeUnit.MINUTES;
        int queueCapacity = config.getRefreshQueueCapacity();
        this.refreshing = new ConcurrentHashMap(queueCapacity);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        RefreshRejectedExecutionHandler rejectedHandler = new RefreshRejectedExecutionHandler();
        this.refreshThreadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final String namePrefix = "autoload-cache-RefreshHandler-";

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "autoload-cache-RefreshHandler-" + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        }, rejectedHandler);
    }

    public void doRefresh(CacheAopProxyChain pjp, Cache cache, CacheKeyTO cacheKey, CacheWrapper<Object> cacheWrapper) {
        int expire = cacheWrapper.getExpire();
        if (expire < 60) {
            return;
        }
        int alarmTime = cache.alarmTime();
        long timeout = alarmTime > 0 && alarmTime < expire ? (long)(expire - alarmTime) : (expire >= 600 ? (long)(expire - 120) : (long)(expire - 60));
        if (System.currentTimeMillis() - cacheWrapper.getLastLoadTime() < timeout * 1000L) {
            return;
        }
        Byte tmpByte = this.refreshing.get(cacheKey);
        if (null != tmpByte) {
            return;
        }
        tmpByte = 1;
        if (null == this.refreshing.putIfAbsent(cacheKey, tmpByte)) {
            try {
                this.refreshThreadPool.execute(new RefreshTask(pjp, cache, cacheKey, cacheWrapper));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.refreshThreadPool.shutdownNow();
    }

    class RefreshRejectedExecutionHandler
    implements RejectedExecutionHandler {
        RefreshRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                Runnable last = (Runnable)e.getQueue().poll();
                if (last instanceof RefreshTask) {
                    RefreshTask lastTask = (RefreshTask)last;
                    RefreshHandler.this.refreshing.remove(lastTask.getCacheKey());
                }
                e.execute(r);
            }
        }
    }

    class RefreshTask
    implements Runnable {
        private final CacheAopProxyChain pjp;
        private final Cache cache;
        private final CacheKeyTO cacheKey;
        private final CacheWrapper<Object> cacheWrapper;
        private final Object[] arguments;

        public RefreshTask(CacheAopProxyChain pjp, Cache cache, CacheKeyTO cacheKey, CacheWrapper<Object> cacheWrapper) throws Exception {
            this.pjp = pjp;
            this.cache = cache;
            this.cacheKey = cacheKey;
            this.cacheWrapper = cacheWrapper;
            this.arguments = RefreshHandler.this.cacheManager.getCloner().deepCloneMethodArgs(pjp.getMethod(), pjp.getArgs());
        }

        @Override
        public void run() {
            DataLoader dataLoader = new DataLoader(this.pjp, this.cacheKey, this.cache, RefreshHandler.this.cacheManager, this.arguments);
            CacheWrapper<Object> newCacheWrapper = null;
            try {
                newCacheWrapper = dataLoader.loadData().getCacheWrapper();
            }
            catch (Throwable ex) {
                logger.error((Object)ex.getMessage(), ex);
            }
            if (dataLoader.isFirst() || null == newCacheWrapper) {
                if (null == newCacheWrapper && null != this.cacheWrapper) {
                    int newExpire = this.cacheWrapper.getExpire() / 2;
                    if (newExpire < 120) {
                        newExpire = 120;
                    }
                    newCacheWrapper = new CacheWrapper<Object>(this.cacheWrapper.getCacheObject(), newExpire);
                }
                try {
                    if (null != newCacheWrapper) {
                        RefreshHandler.this.cacheManager.writeCache(this.pjp, this.arguments, this.cache, this.cacheKey, newCacheWrapper);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            RefreshHandler.this.refreshing.remove(this.cacheKey);
        }

        public CacheKeyTO getCacheKey() {
            return this.cacheKey;
        }
    }
}

