/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.admin.servlet;

import com.jarvis.cache.AbstractCacheManager;
import com.jarvis.cache.admin.servlet.CacheManagerConfig;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.lib.util.BeanUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 252742830396906514L;
    private String user = "admin";
    private String password = "admin";
    private String _cacheManagerConfig;
    private CacheManagerConfig cacheManagerConfig;

    public void init(ServletConfig servletConfig) throws ServletException {
        String _password;
        super.init(servletConfig);
        String _user = servletConfig.getInitParameter("user");
        if (null != _user && _user.length() > 0) {
            this.user = _user;
        }
        if (null != (_password = servletConfig.getInitParameter("password")) && _password.length() > 0) {
            this.password = _password;
        }
        this._cacheManagerConfig = servletConfig.getInitParameter("cacheManagerConfig");
        if (null != this._cacheManagerConfig && this._cacheManagerConfig.length() > 0) {
            try {
                this.cacheManagerConfig = (CacheManagerConfig)Class.forName(this._cacheManagerConfig).newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            throw new ServletException("\u8bf7\u8bbe\u7f6ecom.jarvis.cache.admin.servlet.AdminServlet \u4e2d\u7684 cacheManagerConfig \u53c2\u6570\uff01");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("text/html");
        try {
            AbstractCacheManager cacheManager;
            if (null == this.cacheManagerConfig) {
                String errMsg = "the \"cacheManagerConfig\" is null!";
                resp.getWriter().println(errMsg);
                return;
            }
            String cacheManagerName = req.getParameter("cacheManagerName");
            String[] cacheManagerNames = this.cacheManagerConfig.getCacheManagerNames(req);
            if (null == cacheManagerNames || cacheManagerNames.length == 0) {
                String errMsg = "get \"cacheManagerNames\" is empty!";
                resp.getWriter().println(errMsg);
                return;
            }
            if (null == cacheManagerName || cacheManagerName.trim().length() == 0) {
                cacheManagerName = cacheManagerNames[0];
            }
            if (null == (cacheManager = this.cacheManagerConfig.getCacheManagerByName(req, cacheManagerName))) {
                String errMsg = "get cacheManager by '" + cacheManagerName + "' is null!";
                resp.getWriter().println(errMsg);
                return;
            }
            this.printHtmlHead(resp, cacheManagerName);
            HttpSession session = req.getSession();
            String logined = (String)session.getAttribute("LOGINED");
            String act = req.getParameter("act");
            if (null == logined) {
                String message = null;
                boolean printLoginForm = true;
                if ("login".equals(act)) {
                    String _user = req.getParameter("user");
                    String _password = req.getParameter("password");
                    if (this.user.equals(_user) && this.password.equals(_password)) {
                        session.setAttribute("LOGINED", (Object)"LOGINED");
                        printLoginForm = false;
                        act = null;
                    } else {
                        message = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01";
                    }
                }
                if (printLoginForm) {
                    this.printLoginForm(resp, message);
                }
            }
            if (null != (logined = (String)session.getAttribute("LOGINED"))) {
                if (null != act) {
                    this.doServices(req, resp, cacheManager);
                } else {
                    this.printForm(resp, cacheManagerName, cacheManagerNames);
                    this.printList(req, resp, cacheManager, cacheManagerName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.getWriter().println(e.getMessage());
        }
        this.printCloseHtml(resp);
    }

    private void doServices(HttpServletRequest req, HttpServletResponse resp, AbstractCacheManager cacheManager) throws Exception {
        AutoLoadTO tmpTO;
        String act = req.getParameter("act");
        String cacheKey = req.getParameter("cacheKey");
        String hfield = req.getParameter("hfield");
        CacheKeyTO to = new CacheKeyTO(cacheManager.getNamespace(), cacheKey, hfield);
        if ("removeCache".equals(act)) {
            cacheManager.delete(to);
            resp.getWriter().println("\u5904\u7406\u6210\u529f\uff01");
        } else if ("removeAutoloadTO".equals(act)) {
            cacheManager.getAutoLoadHandler().removeAutoLoadTO(to);
            resp.getWriter().println("\u5904\u7406\u6210\u529f\uff01");
        } else if ("resetLastLoadTime".equals(act)) {
            cacheManager.getAutoLoadHandler().resetAutoLoadLastLoadTime(to);
            resp.getWriter().println("\u5904\u7406\u6210\u529f\uff01");
        } else if ("showArgs".equals(act) && null != (tmpTO = cacheManager.getAutoLoadHandler().getAutoLoadTO(to)) && null != tmpTO.getArgs() && tmpTO.getArgs().length > 0) {
            Object[] args = tmpTO.getArgs();
            int len = args.length;
            StringBuilder html = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                html.append("#args[" + i + "] = ").append(BeanUtil.toString(args[i])).append("<hr/>");
            }
            resp.getWriter().println(html.toString());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void printHtmlHead(HttpServletResponse resp, String cacheManagerName) throws IOException {
        StringBuilder html = new StringBuilder();
        html.append("<html>").append("<head>").append("<title>Cache Admin</title>");
        html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        html.append("<style type=\"text/css\">");
        html.append("th {text-align: center; line-height: 24px; border-top: 1px solid #555555; border-bottom: 1px solid #555555; border-right: 1px solid #555555; word-wrap: break-word; }");
        html.append("table { border-left: 1px solid #555555; }");
        html.append("td { border-right: 1px solid #555555; border-bottom: 1px solid #555555; text-align: center; line-height: 24px; word-wrap: break-word; }");
        html.append("</style>");
        html.append("<script type=\"text/javascript\">");
        html.append("var cacheManagerName=\"" + cacheManagerName + "\";");
        html.append("function removeCache(cacheKey, hfield){if(!cacheKey){return;}");
        html.append("  if(confirm(\"\u786e\u5b9a\u8981\u5220\u9664\u7f13\u5b58?\")){");
        html.append("    document.getElementById(\"act\").value=\"removeCache\";");
        html.append("    document.getElementById(\"cacheKey\").value=cacheKey;");
        html.append("    document.getElementById(\"hfield\").value=hfield;");
        html.append("    document.getElementById(\"cacheManagerName\").value=cacheManagerName;");
        html.append("    document.getElementById(\"updateCacheForm\").submit();");
        html.append("}}");
        html.append("function removeAutoloadTO(cacheKey, hfield){");
        html.append("  if(confirm(\"\u786e\u5b9a\u8981\u5220\u9664?\")){");
        html.append("    document.getElementById(\"act\").value=\"removeAutoloadTO\";");
        html.append("    document.getElementById(\"cacheKey\").value=cacheKey;");
        html.append("    document.getElementById(\"hfield\").value=hfield;");
        html.append("    document.getElementById(\"cacheManagerName\").value=cacheManagerName;");
        html.append("    document.getElementById(\"updateCacheForm\").submit();");
        html.append("}}");
        html.append("function resetLastLoadTime(cacheKey, hfield){");
        html.append("  if(confirm(\"\u786e\u5b9a\u8981\u91cd\u7f6e?\")){");
        html.append("    document.getElementById(\"act\").value=\"resetLastLoadTime\";");
        html.append("    document.getElementById(\"cacheKey\").value=cacheKey;");
        html.append("    document.getElementById(\"hfield\").value=hfield;");
        html.append("    document.getElementById(\"cacheManagerName\").value=cacheManagerName;");
        html.append("    document.getElementById(\"updateCacheForm\").submit();");
        html.append("}}");
        html.append("</script></head><body>");
        resp.getWriter().println(html.toString());
    }

    private void printLoginForm(HttpServletResponse resp, String message) throws IOException {
        StringBuilder html = new StringBuilder();
        if (null != message) {
            html.append("ERROR:" + message);
        }
        html.append("<form  action=\"\" method=\"post\">");
        html.append("user:<input type=\"text\" name=\"user\" />");
        html.append("password:<input type=\"password\" name=\"password\" />");
        html.append("<input type=\"hidden\" id=\"act\" name=\"act\" value=\"login\" />");
        html.append("<input type=\"submit\" value=\"\u767b\u5f55\"></input>");
        html.append("</form>");
        resp.getWriter().println(html.toString());
    }

    private void printForm(HttpServletResponse resp, String cacheManagerName, String[] cacheManagerNames) throws IOException {
        StringBuilder html = new StringBuilder();
        html.append("<form  action=\"\" method=\"get\">");
        html.append("cache manager bean name:");
        html.append("<select name=\"cacheManagerName\">");
        for (String tmpName : cacheManagerNames) {
            html.append("  <option value=\"" + tmpName + "\" " + (tmpName.equals(cacheManagerName) ? "selected" : "") + " >" + tmpName + "</option>");
        }
        html.append("</select>");
        html.append("<input type=\"submit\" value=\"\u66f4\u6539\u7f13\u5b58\"></input>");
        html.append("</form>");
        html.append("cache key:<input type=\"text\" id=\"deleteCacheKey\"/> <input type=\"button\" onclick=\"removeCache(document.getElementById('deleteCacheKey').value)\" value=\"\u5220\u9664\u7f13\u5b58\"/>");
        html.append("<form id=\"updateCacheForm\" action=\"\" method=\"get\" target=\"_blank\">");
        html.append("<input type=\"hidden\" id=\"act\" name=\"act\" value=\"\" />");
        html.append("<input type=\"hidden\" id=\"cacheKey\" name=\"cacheKey\" value=\"\" />");
        html.append("<input type=\"hidden\" id=\"hfield\" name=\"hfield\" value=\"\" />");
        html.append("<input type=\"hidden\" id=\"cacheManagerName\" name=\"cacheManagerName\" value=\"\" />");
        html.append("</form>");
        resp.getWriter().println(html.toString());
    }

    private void printList(HttpServletRequest req, HttpServletResponse resp, AbstractCacheManager cacheManager, String cacheManagerName) throws IOException {
        AutoLoadTO[] queue = cacheManager.getAutoLoadHandler().getAutoLoadQueue();
        if (null == queue || queue.length == 0) {
            resp.getWriter().println("\u81ea\u52a8\u52a0\u8f7d\u961f\u5217\u4e2d\u65e0\u6570\u636e\uff01");
            return;
        }
        StringBuilder html = new StringBuilder();
        html.append("<table cellpadding=\"0\" cellspacing=\"0\">");
        html.append("  <tr>");
        html.append("    <th>namespace </th>");
        html.append("    <th>key </th>");
        html.append("    <th>hash field </th>");
        html.append("    <th>className.method </th>");
        html.append("    <th>last request time </th>");
        html.append("    <th>first request time </th>");
        html.append("    <th>request times </th>");
        html.append("    <th>expire-time(expire) </th>");
        html.append("    <th>request timeout </th>");
        html.append("    <th>last load time </th>");
        html.append("    <th>load count </th>");
        html.append("    <th>average use time </th>");
        html.append("    <th>remove cache </th>");
        html.append("    <th>remove AutoloadTO </th>");
        html.append("    <th>reset last load time </th>");
        html.append("    <th>show arguments </th>");
        html.append("  </tr>");
        for (AutoLoadTO tmpTO : queue) {
            CacheAopProxyChain pjp = tmpTO.getJoinPoint();
            String className = pjp.getTargetClass().getName();
            String methodName = pjp.getMethod().getName();
            CacheKeyTO cacheKeyTO = tmpTO.getCacheKey();
            String _key = cacheKeyTO.getKey();
            String _hfield = cacheKeyTO.getHfield();
            if (null == _hfield) {
                _hfield = "";
            }
            html.append("  <tr>");
            html.append("    <td>" + cacheKeyTO.getNamespace() + "</td>");
            html.append("    <td>" + _key + "</td>");
            html.append("    <td>" + _hfield + "</td>");
            html.append("    <td>" + className + "." + methodName + "</td>");
            html.append("    <td>" + this.getDateFormat(tmpTO.getLastRequestTime()) + "</td>");
            html.append("    <td>" + this.getDateFormat(tmpTO.getFirstRequestTime()) + "</td>");
            html.append("    <td>" + tmpTO.getRequestTimes() + "\u6b21</td>");
            html.append("    <td>" + this.getDateFormat(tmpTO.getLastLoadTime() + (long)(tmpTO.getCache().expire() * 1000)) + "(" + tmpTO.getCache().expire() + "\u79d2)</td>");
            html.append("    <td>" + this.getDateFormat(tmpTO.getLastRequestTime() + tmpTO.getCache().requestTimeout() * 1000L) + "(" + tmpTO.getCache().requestTimeout() + "\u79d2)</td>");
            html.append("    <td>" + this.getDateFormat(tmpTO.getLastLoadTime()) + "</td>");
            html.append("    <td>" + tmpTO.getLoadCnt() + "\u6b21</td>");
            html.append("    <td>" + tmpTO.getAverageUseTime() + "\u6beb\u79d2</td>");
            html.append("    <td><a href=\"javascript:void()\" onclick=\"removeCache('" + _key + "','" + _hfield + "')\">\u5220\u9664\u7f13\u5b58</a></td>");
            html.append("    <td><a href=\"javascript:void()\" onclick=\"removeAutoloadTO('" + _key + "','" + _hfield + "')\">\u79fb\u9664 AutoloadTO</a></td>");
            html.append("    <td><a href=\"javascript:void()\" onclick=\"resetLastLoadTime('" + _key + "','" + _hfield + "')\">\u91cd\u7f6e\u6700\u540e\u52a0\u8f7d\u65f6\u95f4</a></td>");
            html.append("<td>");
            if (null != tmpTO.getArgs() && tmpTO.getArgs().length > 0) {
                html.append("<a href=\"" + req.getContextPath() + req.getServletPath() + "?act=showArgs&cacheManagerName=" + cacheManagerName + "&cacheKey=" + _key + "&hfield=" + _hfield + "\" target=\"_blank\">show args values</a>");
            }
            html.append("</td>");
            html.append("  </tr>");
        }
        html.append("</table>");
        resp.getWriter().println(html.toString());
    }

    private void printCloseHtml(HttpServletResponse resp) throws IOException {
        resp.getWriter().println("</body></html>");
    }

    private String getDateFormat(long time) {
        if (time < 100000L) {
            return "";
        }
        Date date = new Date(time);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/HH:mm:ss");
        return df.format(date);
    }
}

