/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.aop.aspectj;

import com.jarvis.cache.AbstractCacheManager;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.annotation.CacheDelete;
import com.jarvis.cache.aop.aspectj.AspectjCacheAopProxyChain;
import com.jarvis.cache.aop.aspectj.AspectjDeleteCacheAopProxyChain;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public class AspectjAopInterceptor {
    private AbstractCacheManager cacheManager;

    public Object checkAndProceed(ProceedingJoinPoint pjp) throws Throwable {
        Signature signature = pjp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method.isAnnotationPresent(Cache.class)) {
            Cache cache = method.getAnnotation(Cache.class);
            return this.proceed(pjp, cache);
        }
        try {
            return pjp.proceed();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public void checkAndDeleteCache(JoinPoint jp, Object retVal) {
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method.isAnnotationPresent(CacheDelete.class)) {
            CacheDelete cacheDelete = method.getAnnotation(CacheDelete.class);
            this.deleteCache(jp, cacheDelete, retVal);
        }
    }

    public Object proceed(ProceedingJoinPoint aopProxyChain, Cache cache) throws Throwable {
        return this.cacheManager.proceed(new AspectjCacheAopProxyChain(aopProxyChain), cache);
    }

    public void deleteCache(JoinPoint aopProxyChain, CacheDelete cacheDelete, Object retVal) {
        this.cacheManager.deleteCache(new AspectjDeleteCacheAopProxyChain(aopProxyChain), cacheDelete, retVal);
    }

    public AbstractCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(AbstractCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

