/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.map;

import com.jarvis.cache.AbstractCacheManager;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.map.CacheChangeListener;
import com.jarvis.cache.map.CacheTask;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class CachePointCut
extends AbstractCacheManager {
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
    private CacheChangeListener changeListener;
    private int unpersistMaxSize = 0;
    private Thread thread = null;
    private CacheTask cacheTask = null;
    private String persistFile;
    private boolean needPersist = true;
    private boolean copyValue = false;
    private int clearAndPersistPeriod = 60000;

    public CachePointCut(AutoLoadConfig config, ISerializer<Object> serializer, AbstractScriptParser scriptParser) {
        super(config, serializer, scriptParser);
        config.setCheckFromCacheBeforeLoad(false);
        this.cacheTask = new CacheTask(this);
        this.changeListener = this.cacheTask;
    }

    public synchronized void start() {
        if (null == this.thread) {
            this.thread = new Thread(this.cacheTask);
            this.cacheTask.start();
            this.thread.start();
        }
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.cacheTask.destroy();
    }

    @Override
    public void setCache(CacheKeyTO cacheKeyTO, CacheWrapper<Object> result, Method method, Object[] args) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return;
        }
        CacheWrapper value = null;
        if (this.copyValue) {
            try {
                value = (CacheWrapper)this.getCloner().deepClone(result, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            value = result;
        }
        SoftReference<CacheWrapper<Object>> reference = new SoftReference<CacheWrapper<Object>>(value);
        String hfield = cacheKeyTO.getHfield();
        if (null == hfield || hfield.length() == 0) {
            this.cache.put(cacheKey, reference);
        } else {
            ConcurrentHashMap<String, SoftReference<CacheWrapper<Object>>> hash = (ConcurrentHashMap<String, SoftReference<CacheWrapper<Object>>>)this.cache.get(cacheKey);
            if (null == hash) {
                hash = new ConcurrentHashMap<String, SoftReference<CacheWrapper<Object>>>();
                ConcurrentHashMap _hash = null;
                _hash = this.cache.putIfAbsent(cacheKey, hash);
                if (null != _hash) {
                    hash = _hash;
                }
            }
            hash.put(hfield, reference);
        }
        this.changeListener.cacheChange();
    }

    @Override
    public CacheWrapper<Object> get(CacheKeyTO cacheKeyTO, Method method, Object[] args) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return null;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return null;
        }
        Object obj = this.cache.get(cacheKey);
        if (null == obj) {
            return null;
        }
        String hfield = cacheKeyTO.getHfield();
        CacheWrapper value = null;
        if (null == hfield || hfield.length() == 0) {
            if (obj instanceof SoftReference) {
                SoftReference reference = (SoftReference)obj;
                if (null != reference) {
                    value = (CacheWrapper)reference.get();
                }
            } else if (obj instanceof CacheWrapper) {
                value = (CacheWrapper)obj;
            }
        } else {
            ConcurrentHashMap hash = (ConcurrentHashMap)obj;
            Object tmp = hash.get(hfield);
            if (tmp instanceof SoftReference) {
                SoftReference reference = (SoftReference)tmp;
                if (null != reference) {
                    value = (CacheWrapper)reference.get();
                }
            } else if (tmp instanceof CacheWrapper) {
                value = (CacheWrapper)tmp;
            }
        }
        if (this.copyValue) {
            try {
                CacheWrapper<Object> res = new CacheWrapper<Object>();
                res.setExpire(value.getExpire());
                res.setLastLoadTime(value.getLastLoadTime());
                res.setCacheObject(this.getCloner().deepClone(value.getCacheObject(), method.getReturnType()));
                return res;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    @Override
    public void delete(CacheKeyTO cacheKeyTO) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return;
        }
        String hfield = cacheKeyTO.getHfield();
        if (null == hfield || hfield.length() == 0) {
            ConcurrentHashMap hash;
            Object tmp = this.cache.remove(cacheKey);
            if (null == tmp) {
                return;
            }
            if (tmp instanceof CacheWrapper) {
                this.changeListener.cacheChange();
            } else if (tmp instanceof ConcurrentHashMap && (hash = (ConcurrentHashMap)tmp).size() > 0) {
                this.changeListener.cacheChange(hash.size());
            }
        } else {
            Object tmp;
            ConcurrentHashMap hash = (ConcurrentHashMap)this.cache.get(cacheKey);
            if (null != hash && null != (tmp = hash.remove(hfield))) {
                this.changeListener.cacheChange();
            }
        }
    }

    public ConcurrentHashMap<String, Object> getCache() {
        return this.cache;
    }

    public String getPersistFile() {
        return this.persistFile;
    }

    public void setPersistFile(String persistFile) {
        this.persistFile = persistFile;
    }

    public boolean isNeedPersist() {
        return this.needPersist;
    }

    public void setNeedPersist(boolean needPersist) {
        this.needPersist = needPersist;
    }

    public int getUnpersistMaxSize() {
        return this.unpersistMaxSize;
    }

    public void setUnpersistMaxSize(int unpersistMaxSize) {
        if (unpersistMaxSize > 0) {
            this.unpersistMaxSize = unpersistMaxSize;
        }
    }

    public boolean isCopyValue() {
        return this.copyValue;
    }

    public void setCopyValue(boolean copyValue) {
        this.copyValue = copyValue;
    }

    public int getClearAndPersistPeriod() {
        return this.clearAndPersistPeriod;
    }

    public void setClearAndPersistPeriod(int clearAndPersistPeriod) {
        this.clearAndPersistPeriod = clearAndPersistPeriod;
    }
}

