/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.map;

import com.jarvis.cache.map.CacheChangeListener;
import com.jarvis.cache.map.CachePointCut;
import com.jarvis.cache.serializer.HessianSerializer;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.lib.util.OsUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class CacheTask
implements Runnable,
CacheChangeListener {
    private static final Logger logger = Logger.getLogger(CacheTask.class);
    private AtomicInteger cacheChanged = new AtomicInteger(0);
    private CachePointCut cacheManager;
    private volatile boolean running = false;
    private File saveFile;
    private ISerializer<Object> persistSerializer;

    public CacheTask(CachePointCut cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void start() {
        if (!this.running) {
            this.loadCache();
            this.running = true;
        }
    }

    public void destroy() {
        this.persistCache(true);
        this.running = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.running = false;
    }

    private String getSavePath() {
        String persistFile = this.cacheManager.getPersistFile();
        if (null != persistFile && persistFile.trim().length() > 0) {
            return persistFile;
        }
        String path = "/tmp/autoload-cache/";
        String nsp = this.cacheManager.getNamespace();
        if (null != nsp && nsp.trim().length() > 0) {
            path = path + nsp.trim() + "/";
        }
        if (OsUtil.getInstance().isLinux()) {
            return path;
        }
        return "C:" + path;
    }

    private File getSaveFile() {
        if (null != this.saveFile) {
            return this.saveFile;
        }
        String path = this.getSavePath();
        File savePath = new File(path);
        if (!savePath.exists()) {
            savePath.mkdirs();
        }
        this.saveFile = new File(path + "map.cache");
        return this.saveFile;
    }

    private ISerializer<Object> getPersistSerializer() {
        if (null == this.persistSerializer) {
            this.persistSerializer = null != this.cacheManager.getSerializer() && this.cacheManager.getSerializer() instanceof HessianSerializer ? this.cacheManager.getSerializer() : new HessianSerializer();
        }
        return this.persistSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCache() {
        File file = this.getSaveFile();
        if (null == file) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        BufferedInputStream bis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = -1;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            byte[] retArr = baos.toByteArray();
            Object obj = this.getPersistSerializer().deserialize(retArr, null);
            if (null != obj && obj instanceof ConcurrentHashMap) {
                this.cacheManager.getCache().putAll((ConcurrentHashMap)obj);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (null != bis) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistCache(boolean force) {
        if (!this.cacheManager.isNeedPersist()) {
            return;
        }
        int cnt = this.cacheChanged.intValue();
        if (!force && cnt <= this.cacheManager.getUnpersistMaxSize()) {
            return;
        }
        this.cacheChanged.set(0);
        FileOutputStream fos = null;
        try {
            byte[] data = this.getPersistSerializer().serialize(this.cacheManager.getCache());
            File file = this.getSaveFile();
            fos = new FileOutputStream(file);
            fos.write(data);
        }
        catch (Exception ex) {
            this.cacheChanged.addAndGet(cnt);
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.cleanCache();
                this.persistCache(false);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                Thread.sleep(this.cacheManager.getClearAndPersistPeriod());
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void cleanCache() {
        Iterator<Map.Entry<String, Object>> iterator = this.cacheManager.getCache().entrySet().iterator();
        int _cacheChanged = 0;
        int i = 0;
        while (iterator.hasNext()) {
            _cacheChanged += this.removeExpiredItem(iterator);
            if (++i != 2000) continue;
            i = 0;
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (_cacheChanged > 0) {
            this.cacheChange(_cacheChanged);
        }
    }

    private int removeExpiredItem(Iterator<Map.Entry<String, Object>> iterator) {
        int _cacheChanged = 0;
        Object value = iterator.next().getValue();
        if (value instanceof SoftReference) {
            SoftReference reference = (SoftReference)value;
            if (null != reference && null != reference.get()) {
                CacheWrapper tmp = (CacheWrapper)reference.get();
                if (tmp.isExpired()) {
                    iterator.remove();
                    ++_cacheChanged;
                }
            } else {
                iterator.remove();
                ++_cacheChanged;
            }
        } else if (value instanceof ConcurrentHashMap) {
            ConcurrentHashMap hash = (ConcurrentHashMap)value;
            Iterator iterator2 = hash.entrySet().iterator();
            while (iterator2.hasNext()) {
                CacheWrapper tmp;
                Object tmpObj = iterator2.next().getValue();
                if (tmpObj instanceof SoftReference) {
                    SoftReference reference = (SoftReference)tmpObj;
                    if (null != reference && null != reference.get()) {
                        CacheWrapper tmp2 = (CacheWrapper)reference.get();
                        if (!tmp2.isExpired()) continue;
                        iterator2.remove();
                        ++_cacheChanged;
                        continue;
                    }
                    iterator2.remove();
                    ++_cacheChanged;
                    continue;
                }
                if (!(tmpObj instanceof CacheWrapper) || !(tmp = (CacheWrapper)tmpObj).isExpired()) continue;
                iterator2.remove();
                ++_cacheChanged;
            }
            if (hash.isEmpty()) {
                iterator.remove();
            }
        } else {
            CacheWrapper tmp = (CacheWrapper)value;
            if (tmp.isExpired()) {
                iterator.remove();
                ++_cacheChanged;
            }
        }
        return _cacheChanged;
    }

    @Override
    public void cacheChange() {
        this.cacheChanged.incrementAndGet();
    }

    @Override
    public void cacheChange(int cnt) {
        this.cacheChanged.addAndGet(cnt);
    }
}

