/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.AbstractCacheManager;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.StringSerializer;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class ShardedCachePointCut
extends AbstractCacheManager {
    private static final Logger logger = Logger.getLogger(ShardedCachePointCut.class);
    private static final StringSerializer keySerializer = new StringSerializer();
    private ShardedJedisPool shardedJedisPool;
    private int hashExpire = -1;
    private boolean hashExpireByScript = false;
    private static byte[] hashSetScript;
    private static final Map<Jedis, byte[]> hashSetScriptSha;
    private static byte[] delScript;
    private static final Map<Jedis, byte[]> delScriptSha;

    public ShardedCachePointCut(AutoLoadConfig config, ISerializer<Object> serializer, AbstractScriptParser scriptParser) {
        super(config, serializer, scriptParser);
    }

    private void returnResource(ShardedJedis shardedJedis) {
        shardedJedis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCache(CacheKeyTO cacheKeyTO, CacheWrapper<Object> result, Method method, Object[] args) throws CacheCenterConnectionException {
        if (null == this.shardedJedisPool || null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return;
        }
        ShardedJedis shardedJedis = null;
        try {
            int expire = result.getExpire();
            shardedJedis = this.shardedJedisPool.getResource();
            Jedis jedis = (Jedis)shardedJedis.getShard(cacheKey);
            String hfield = cacheKeyTO.getHfield();
            if (null == hfield || hfield.length() == 0) {
                if (expire == 0) {
                    jedis.set(keySerializer.serialize(cacheKey), this.getSerializer().serialize(result));
                } else {
                    jedis.setex(keySerializer.serialize(cacheKey), expire, this.getSerializer().serialize(result));
                }
            } else {
                this.hashSet(jedis, cacheKey, hfield, result);
            }
            this.returnResource(shardedJedis);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                this.returnResource(shardedJedis);
            }
            catch (Throwable throwable) {
                this.returnResource(shardedJedis);
                throw throwable;
            }
        }
    }

    private void hashSet(Jedis jedis, String cacheKey, String hfield, CacheWrapper<Object> result) throws Exception {
        byte[] key = keySerializer.serialize(cacheKey);
        byte[] field = keySerializer.serialize(hfield);
        byte[] val = this.getSerializer().serialize(result);
        int hExpire = this.hashExpire < 0 ? result.getExpire() : this.hashExpire;
        if (hExpire == 0) {
            jedis.hset(key, field, val);
        } else if (this.hashExpireByScript) {
            byte[] sha = hashSetScriptSha.get(jedis);
            if (null == sha) {
                sha = jedis.scriptLoad(hashSetScript);
                hashSetScriptSha.put(jedis, sha);
            }
            ArrayList<byte[]> keys = new ArrayList<byte[]>();
            keys.add(key);
            keys.add(field);
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(val);
            args.add(keySerializer.serialize(String.valueOf(hExpire)));
            try {
                jedis.evalsha(sha, keys, args);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                try {
                    sha = jedis.scriptLoad(hashSetScript);
                    hashSetScriptSha.put(jedis, sha);
                    jedis.evalsha(sha, keys, args);
                }
                catch (Exception ex1) {
                    logger.error((Object)ex1.getMessage(), (Throwable)ex1);
                }
            }
        } else {
            Pipeline p = jedis.pipelined();
            p.hset(key, field, val);
            p.expire(key, hExpire);
            p.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheWrapper<Object> get(CacheKeyTO cacheKeyTO, Method method, Object[] args) throws CacheCenterConnectionException {
        if (null == this.shardedJedisPool || null == cacheKeyTO) {
            return null;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return null;
        }
        CacheWrapper res = null;
        ShardedJedis shardedJedis = null;
        try {
            shardedJedis = this.shardedJedisPool.getResource();
            Jedis jedis = (Jedis)shardedJedis.getShard(cacheKey);
            byte[] bytes = null;
            String hfield = cacheKeyTO.getHfield();
            bytes = null == hfield || hfield.length() == 0 ? jedis.get(keySerializer.serialize(cacheKey)) : jedis.hget(keySerializer.serialize(cacheKey), keySerializer.serialize(hfield));
            Type returnType = method.getGenericReturnType();
            res = (CacheWrapper)this.getSerializer().deserialize(bytes, returnType);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.returnResource(shardedJedis);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(CacheKeyTO cacheKeyTO) throws CacheCenterConnectionException {
        if (null == this.shardedJedisPool || null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return;
        }
        logger.debug((Object)("delete cache:" + cacheKey));
        ShardedJedis shardedJedis = null;
        try {
            shardedJedis = this.shardedJedisPool.getResource();
            if ("*".equals(cacheKey)) {
                Collection list = shardedJedis.getAllShards();
                for (Jedis jedis : list) {
                    jedis.flushDB();
                }
            } else if (cacheKey.indexOf("*") != -1) {
                this.batchDel(shardedJedis, cacheKey);
            } else {
                Jedis jedis = (Jedis)shardedJedis.getShard(cacheKey);
                String hfield = cacheKeyTO.getHfield();
                if (null == hfield || hfield.length() == 0) {
                    jedis.del(keySerializer.serialize(cacheKey));
                } else {
                    jedis.hdel(keySerializer.serialize(cacheKey), (byte[][])new byte[][]{keySerializer.serialize(hfield)});
                }
                this.getAutoLoadHandler().resetAutoLoadLastLoadTime(cacheKeyTO);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.returnResource(shardedJedis);
        }
    }

    private void batchDel(ShardedJedis shardedJedis, String cacheKey) throws Exception {
        Collection list = shardedJedis.getAllShards();
        for (Jedis jedis : list) {
            byte[] sha = delScriptSha.get(jedis);
            byte[] key = keySerializer.serialize(cacheKey);
            if (null == sha) {
                sha = jedis.scriptLoad(delScript);
                delScriptSha.put(jedis, sha);
            }
            try {
                List keys = (List)jedis.evalsha(sha, 1, (byte[][])new byte[][]{key});
                if (null != keys && keys.size() <= 0) continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                try {
                    sha = jedis.scriptLoad(delScript);
                    delScriptSha.put(jedis, sha);
                    List keys = (List)jedis.evalsha(sha, 1, (byte[][])new byte[][]{key});
                    if (null != keys && keys.size() <= 0) continue;
                }
                catch (Exception ex1) {
                    logger.error((Object)ex1.getMessage(), (Throwable)ex1);
                }
            }
        }
    }

    public ShardedJedisPool getShardedJedisPool() {
        return this.shardedJedisPool;
    }

    public void setShardedJedisPool(ShardedJedisPool shardedJedisPool) {
        this.shardedJedisPool = shardedJedisPool;
    }

    public int getHashExpire() {
        return this.hashExpire;
    }

    public void setHashExpire(int hashExpire) {
        if (hashExpire < 0) {
            return;
        }
        this.hashExpire = hashExpire;
    }

    public boolean isHashExpireByScript() {
        return this.hashExpireByScript;
    }

    public void setHashExpireByScript(boolean hashExpireByScript) {
        this.hashExpireByScript = hashExpireByScript;
    }

    static {
        try {
            String tmpScript = "redis.call('HSET', KEYS[1], KEYS[2], ARGV[1]);\nredis.call('EXPIRE', KEYS[1], tonumber(ARGV[2]));";
            hashSetScript = tmpScript.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        hashSetScriptSha = new ConcurrentHashMap<Jedis, byte[]>();
        StringBuilder tmp = new StringBuilder();
        tmp.append("local keys = redis.call('keys', KEYS[1]);\n");
        tmp.append("if(not keys or #keys == 0) then \n return nil; \n end \n");
        tmp.append("redis.call('del', unpack(keys)); \n return keys;");
        try {
            delScript = tmp.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        delScriptSha = new ConcurrentHashMap<Jedis, byte[]>();
    }
}

