/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.script;

import com.jarvis.cache.CacheUtil;
import com.jarvis.cache.script.AbstractScriptParser;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.log4j.Logger;

public class JavaScriptParser
extends AbstractScriptParser {
    private static final Logger logger = Logger.getLogger(JavaScriptParser.class);
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ConcurrentHashMap<String, CompiledScript> expCache = new ConcurrentHashMap();
    private final StringBuffer funcs = new StringBuffer();
    private static int versionCode;
    private final ScriptEngine engine = this.manager.getEngineByName(versionCode >= 18 ? "nashorn" : "javascript");

    public JavaScriptParser() {
        try {
            this.addFunction("hash", CacheUtil.class.getDeclaredMethod("getUniqueHashStr", Object.class));
            this.addFunction("empty", CacheUtil.class.getDeclaredMethod("isEmpty", Object.class));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addFunction(String name, Method method) {
        try {
            String clsName = method.getDeclaringClass().getName();
            String methodName = method.getName();
            this.funcs.append("function " + name + "(obj){return " + clsName + "." + methodName + "(obj);}");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T> T getElValue(String exp, Object[] arguments, Object retVal, boolean hasRetVal, Class<T> valueType) throws Exception {
        CompiledScript script;
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("args", (Object)arguments);
        if (hasRetVal) {
            bindings.put("retVal", retVal);
        }
        if (null != (script = this.expCache.get(exp))) {
            return (T)script.eval(bindings);
        }
        if (this.engine instanceof Compilable) {
            Compilable compEngine = (Compilable)((Object)this.engine);
            script = compEngine.compile(this.funcs + exp);
            this.expCache.put(exp, script);
            return (T)script.eval(bindings);
        }
        return (T)this.engine.eval(this.funcs + exp, (Bindings)bindings);
    }

    static {
        String javaVersion = System.getProperty("java.version");
        int ind = 0;
        for (int i = 0; i < 2; ++i) {
            ind = javaVersion.indexOf(".", ind);
            ++ind;
        }
        javaVersion = javaVersion.substring(0, ind);
        javaVersion = javaVersion.replaceAll("\\.", "");
        versionCode = Integer.parseInt(javaVersion);
    }
}

