/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.script;

import com.jarvis.cache.CacheUtil;
import com.jarvis.cache.script.AbstractScriptParser;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.Ognl;
import ognl.OgnlContext;

public class OgnlParser
extends AbstractScriptParser {
    private final ConcurrentHashMap<String, Object> expCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> funcs = new ConcurrentHashMap(64);

    @Override
    public void addFunction(String name, Method method) {
        this.funcs.put(name, method.getDeclaringClass());
    }

    @Override
    public <T> T getElValue(String exp, Object[] arguments, Object retVal, boolean hasRetVal, Class<T> valueType) throws Exception {
        Object object = this.expCache.get(exp);
        if (null == object) {
            String className = CacheUtil.class.getName();
            String exp2 = exp.replaceAll("@@hash\\(", "@" + className + "@getUniqueHashStr(");
            exp2 = exp.replaceAll("@@empty\\(", "@" + className + "@isEmpty(");
            for (Map.Entry<String, Class<?>> entry : this.funcs.entrySet()) {
                className = entry.getValue().getName();
                exp.replaceAll("@@" + entry.getKey() + "\\(", "@" + className + "@" + entry.getKey() + "(");
            }
            object = Ognl.parseExpression((String)exp2);
            this.expCache.put(exp, object);
        }
        OgnlContext context = new OgnlContext();
        context.put((Object)"args", (Object)arguments);
        if (hasRetVal) {
            context.put((Object)"retVal", retVal);
        }
        context.setRoot((Object)arguments);
        Object res = Ognl.getValue((Object)object, (Map)context, (Object)context.getRoot(), valueType);
        return (T)res;
    }
}

