/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import com.jarvis.cache.serializer.HessionBigDecimalSerializerFactory;
import com.jarvis.cache.serializer.HessionSoftReferenceSerializerFactory;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.lib.util.BeanUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;

public class HessianSerializer
implements ISerializer<Object> {
    private static final SerializerFactory serializerFactory = new SerializerFactory();

    public void addSerializerFactory(AbstractSerializerFactory factory) {
        serializerFactory.addFactory(factory);
    }

    @Override
    public byte[] serialize(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Hessian2Output output = new Hessian2Output((OutputStream)outputStream);
        output.setSerializerFactory(serializerFactory);
        output.writeObject(obj);
        output.flush();
        byte[] val = outputStream.toByteArray();
        output.close();
        return val;
    }

    @Override
    public Object deserialize(byte[] bytes, Type returnType) throws Exception {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Hessian2Input input = new Hessian2Input((InputStream)inputStream);
        input.setSerializerFactory(serializerFactory);
        Object obj = input.readObject();
        input.close();
        return obj;
    }

    @Override
    public Object deepClone(Object obj, Type type) throws Exception {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (BeanUtil.isPrimitive(obj) || clazz.isEnum() || obj instanceof Class || clazz.isAnnotation() || clazz.isSynthetic()) {
            return obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).clone();
        }
        if (obj instanceof Calendar) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Calendar)obj).getTime().getTime());
            return cal;
        }
        return this.deserialize(this.serialize(obj), null);
    }

    @Override
    public Object[] deepCloneMethodArgs(Method method, Object[] args) throws Exception {
        if (null == args || args.length == 0) {
            return args;
        }
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (args.length != genericParameterTypes.length) {
            throw new Exception("the length of " + method.getDeclaringClass().getName() + "." + method.getName() + " must " + genericParameterTypes.length);
        }
        Object[] res = new Object[args.length];
        int len = genericParameterTypes.length;
        for (int i = 0; i < len; ++i) {
            res[i] = this.deepClone(args[i], null);
        }
        return res;
    }

    static {
        serializerFactory.addFactory((AbstractSerializerFactory)new HessionBigDecimalSerializerFactory());
        serializerFactory.addFactory((AbstractSerializerFactory)new HessionSoftReferenceSerializerFactory());
    }
}

