/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer;

import com.jarvis.cache.serializer.ISerializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public class StringSerializer
implements ISerializer<String> {
    private final Charset charset;

    public StringSerializer() {
        this(Charset.forName("UTF8"));
    }

    public StringSerializer(Charset charset) {
        this.charset = charset;
    }

    @Override
    public String deserialize(byte[] bytes, Type returnType) throws Exception {
        return bytes == null ? null : new String(bytes, this.charset);
    }

    @Override
    public byte[] serialize(String string) throws Exception {
        return string == null ? null : string.getBytes(this.charset);
    }

    @Override
    public Object deepClone(Object obj, Type type) throws Exception {
        if (null == obj) {
            return obj;
        }
        String str = (String)obj;
        return String.copyValueOf(str.toCharArray());
    }

    @Override
    public Object[] deepCloneMethodArgs(Method method, Object[] args) throws Exception {
        return (Object[])this.deepClone(args, null);
    }
}

