/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.to;

import com.jarvis.cache.type.AutoLoadQueueSortType;
import java.util.Map;

public class AutoLoadConfig {
    private Integer threadCnt = 10;
    private int maxElement = 20000;
    private boolean printSlowLog = true;
    private int slowLoadTime = 500;
    private AutoLoadQueueSortType sortType = AutoLoadQueueSortType.NONE;
    private boolean checkFromCacheBeforeLoad = false;
    private int autoLoadPeriod = 50;
    private int refreshThreadPoolSize = 2;
    private int refreshThreadPoolMaxSize = 20;
    private int refreshThreadPoolkeepAliveTime = 20;
    private int refreshQueueCapacity = 2000;
    private Map<String, String> functions;

    public int getThreadCnt() {
        return this.threadCnt;
    }

    public void setThreadCnt(int threadCnt) {
        if (threadCnt <= 0) {
            return;
        }
        this.threadCnt = threadCnt;
    }

    public int getMaxElement() {
        return this.maxElement;
    }

    public void setMaxElement(int maxElement) {
        if (maxElement <= 0) {
            return;
        }
        this.maxElement = maxElement;
    }

    public AutoLoadQueueSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(Integer sortType) {
        this.sortType = AutoLoadQueueSortType.getById(sortType);
    }

    public boolean isPrintSlowLog() {
        return this.printSlowLog;
    }

    public void setPrintSlowLog(boolean printSlowLog) {
        this.printSlowLog = printSlowLog;
    }

    public int getSlowLoadTime() {
        return this.slowLoadTime;
    }

    public void setSlowLoadTime(int slowLoadTime) {
        if (slowLoadTime < 0) {
            return;
        }
        this.slowLoadTime = slowLoadTime;
    }

    public boolean isCheckFromCacheBeforeLoad() {
        return this.checkFromCacheBeforeLoad;
    }

    public void setCheckFromCacheBeforeLoad(boolean checkFromCacheBeforeLoad) {
        this.checkFromCacheBeforeLoad = checkFromCacheBeforeLoad;
    }

    public int getAutoLoadPeriod() {
        return this.autoLoadPeriod;
    }

    public void setAutoLoadPeriod(int autoLoadPeriod) {
        if (autoLoadPeriod < 5) {
            return;
        }
        this.autoLoadPeriod = autoLoadPeriod;
    }

    public void setFunctions(Map<String, String> funcs) {
        if (null == funcs || funcs.isEmpty()) {
            return;
        }
        this.functions = funcs;
    }

    public Map<String, String> getFunctions() {
        return this.functions;
    }

    public int getRefreshThreadPoolSize() {
        return this.refreshThreadPoolSize;
    }

    public void setRefreshThreadPoolSize(int refreshThreadPoolSize) {
        if (refreshThreadPoolSize > 1) {
            this.refreshThreadPoolSize = refreshThreadPoolSize;
        }
    }

    public int getRefreshThreadPoolMaxSize() {
        return this.refreshThreadPoolMaxSize;
    }

    public void setRefreshThreadPoolMaxSize(int refreshThreadPoolMaxSize) {
        if (refreshThreadPoolMaxSize > 1) {
            this.refreshThreadPoolMaxSize = refreshThreadPoolMaxSize;
        }
    }

    public int getRefreshThreadPoolkeepAliveTime() {
        return this.refreshThreadPoolkeepAliveTime;
    }

    public void setRefreshThreadPoolkeepAliveTime(int refreshThreadPoolkeepAliveTime) {
        if (refreshThreadPoolkeepAliveTime > 1) {
            this.refreshThreadPoolkeepAliveTime = refreshThreadPoolkeepAliveTime;
        }
    }

    public int getRefreshQueueCapacity() {
        return this.refreshQueueCapacity;
    }

    public void setRefreshQueueCapacity(int refreshQueueCapacity) {
        if (refreshQueueCapacity > 1) {
            this.refreshQueueCapacity = refreshQueueCapacity;
        }
    }
}

