/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.to;

import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.CacheKeyTO;
import java.io.Serializable;

public class AutoLoadTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CacheAopProxyChain joinPoint;
    private final Object[] args;
    private final Cache cache;
    private int expire;
    private final CacheKeyTO cacheKey;
    private long lastLoadTime = 0L;
    private long lastRequestTime = 0L;
    private long firstRequestTime = 0L;
    private long requestTimes = 0L;
    private volatile boolean loading = false;
    private long loadCnt = 0L;
    private long useTotalTime = 0L;

    public AutoLoadTO(CacheKeyTO cacheKey, CacheAopProxyChain joinPoint, Object[] args, Cache cache, int expire) {
        this.cacheKey = cacheKey;
        this.joinPoint = joinPoint;
        this.args = args;
        this.cache = cache;
        this.expire = expire;
    }

    public CacheAopProxyChain getJoinPoint() {
        return this.joinPoint;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoLoadTO setLastRequestTime(long lastRequestTime) {
        AutoLoadTO autoLoadTO = this;
        synchronized (autoLoadTO) {
            this.lastRequestTime = lastRequestTime;
            if (this.firstRequestTime == 0L) {
                this.firstRequestTime = lastRequestTime;
            }
            ++this.requestTimes;
        }
        return this;
    }

    public long getFirstRequestTime() {
        return this.firstRequestTime;
    }

    public long getRequestTimes() {
        return this.requestTimes;
    }

    public Cache getCache() {
        return this.cache;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public AutoLoadTO setLastLoadTime(long lastLoadTime) {
        if (lastLoadTime > this.lastLoadTime) {
            this.lastLoadTime = lastLoadTime;
        }
        return this;
    }

    public CacheKeyTO getCacheKey() {
        return this.cacheKey;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public AutoLoadTO setLoading(boolean loading) {
        this.loading = loading;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public long getLoadCnt() {
        return this.loadCnt;
    }

    public long getUseTotalTime() {
        return this.useTotalTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoLoadTO addUseTotalTime(long useTime) {
        AutoLoadTO autoLoadTO = this;
        synchronized (autoLoadTO) {
            ++this.loadCnt;
            this.useTotalTime += this.useTotalTime;
        }
        return this;
    }

    public long getAverageUseTime() {
        if (this.loadCnt == 0L) {
            return 0L;
        }
        return this.useTotalTime / this.loadCnt;
    }

    public int getExpire() {
        return this.expire;
    }

    public AutoLoadTO setExpire(int expire) {
        this.expire = expire;
        return this;
    }
}

