/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.to;

import java.io.Serializable;

public class CacheWrapper<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private T cacheObject;
    private long lastLoadTime;
    private int expire;

    public CacheWrapper() {
    }

    public CacheWrapper(T cacheObject, int expire) {
        this.cacheObject = cacheObject;
        this.lastLoadTime = System.currentTimeMillis();
        this.expire = expire;
    }

    public boolean isExpired() {
        if (this.expire > 0) {
            return System.currentTimeMillis() - this.lastLoadTime > (long)(this.expire * 1000);
        }
        return false;
    }

    public T getCacheObject() {
        return this.cacheObject;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setCacheObject(T cacheObject) {
        this.cacheObject = cacheObject;
    }

    public void setLastLoadTime(long lastLoadTime) {
        this.lastLoadTime = lastLoadTime;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheWrapper)) {
            return false;
        }
        CacheWrapper other = (CacheWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$cacheObject = this.getCacheObject();
        T other$cacheObject = other.getCacheObject();
        if (this$cacheObject == null ? other$cacheObject != null : !this$cacheObject.equals(other$cacheObject)) {
            return false;
        }
        if (this.getLastLoadTime() != other.getLastLoadTime()) {
            return false;
        }
        return this.getExpire() == other.getExpire();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $cacheObject = this.getCacheObject();
        result = result * 59 + ($cacheObject == null ? 43 : $cacheObject.hashCode());
        long $lastLoadTime = this.getLastLoadTime();
        result = result * 59 + (int)($lastLoadTime >>> 32 ^ $lastLoadTime);
        result = result * 59 + this.getExpire();
        return result;
    }

    public String toString() {
        return "CacheWrapper(cacheObject=" + this.getCacheObject() + ", lastLoadTime=" + this.getLastLoadTime() + ", expire=" + this.getExpire() + ")";
    }
}

