/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.mvc.result;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrick.web.mvc.Managed;
import jetbrick.web.mvc.RequestContext;
import jetbrick.web.mvc.result.MimetypeUtils;
import jetbrick.web.mvc.result.ResultHandler;

@Managed(value={JSONAware.class, JSONObject.class, JSONArray.class})
public final class FastjsonResultHandler
implements ResultHandler<JSONAware> {
    public void handle(RequestContext ctx, JSONAware result) throws IOException {
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        if (result == null) {
            JSONObject json = new JSONObject();
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                json.put(name, request.getAttribute(name));
            }
            for (Map.Entry entry : ctx.getModel().entrySet()) {
                json.put((String)entry.getKey(), entry.getValue());
            }
            result = json;
        }
        String characterEncoding = request.getCharacterEncoding();
        response.setCharacterEncoding(characterEncoding);
        String mimetype = MimetypeUtils.getJSON((HttpServletRequest)request);
        response.setContentType(mimetype + "; charset=" + characterEncoding);
        String callback = ctx.getParameter("callback");
        PrintWriter out = response.getWriter();
        if (callback != null) {
            out.write(callback + '(' + result.toJSONString() + ')');
        } else {
            out.write(result.toJSONString());
        }
        out.flush();
    }
}

