/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.timer;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public final class Rx2Timer {
    private Disposable disposable;
    private long take;
    private long period;
    private long initialDelay;
    private TimeUnit unit;
    private OnComplete onComplete;
    private OnCount onCount;
    private OnError onError;
    private long pauseTake = 0L;
    private long resumeTake = 0L;
    private boolean isPause = false;

    private Rx2Timer(Builder builder) {
        this.take = builder.take;
        this.period = builder.period;
        this.initialDelay = builder.initialDelay;
        this.unit = builder.unit;
        this.onComplete = builder.onComplete;
        this.onCount = builder.onCount;
        this.onError = builder.onError;
    }

    public boolean isPause() {
        return this.isPause;
    }

    public Rx2Timer restart() {
        this.stop();
        return this.start();
    }

    public Rx2Timer start() {
        if (this.isPause) {
            return this.restart();
        }
        if (this.disposable == null || this.disposable.isDisposed()) {
            this.disposable = Observable.interval((long)this.initialDelay, (long)this.period, (TimeUnit)this.unit).subscribeOn(Schedulers.single()).take(this.take + 1L).map((Function)new Function<Long, Long>(){

                public Long apply(@NonNull Long aLong) throws Exception {
                    Rx2Timer.this.pauseTake = aLong;
                    return Rx2Timer.this.take - aLong;
                }
            }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(@NonNull Long aLong) throws Exception {
                    if (Rx2Timer.this.onCount != null) {
                        Rx2Timer.this.onCount.onCount(aLong);
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(@NonNull Throwable throwable) throws Exception {
                    if (Rx2Timer.this.onError != null) {
                        Rx2Timer.this.onError.onError(throwable);
                    }
                }
            }, new Action(){

                public void run() throws Exception {
                    if (Rx2Timer.this.onComplete != null) {
                        Rx2Timer.this.onComplete.onComplete();
                    }
                }
            });
        }
        return this;
    }

    public void stop() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
        if (this.isPause) {
            this.cleanPauseState();
        }
    }

    public void pause() {
        if (this.isPause) {
            return;
        }
        this.stop();
        this.isPause = true;
        this.resumeTake += this.pauseTake;
    }

    public void resume() {
        if (!this.isPause) {
            return;
        }
        this.isPause = false;
        if (this.disposable == null || this.disposable.isDisposed()) {
            this.disposable = Observable.interval((long)this.initialDelay, (long)this.period, (TimeUnit)this.unit).subscribeOn(Schedulers.single()).take(this.take + 1L - this.resumeTake).map((Function)new Function<Long, Long>(){

                public Long apply(@NonNull Long aLong) throws Exception {
                    Rx2Timer.this.pauseTake = aLong;
                    return Rx2Timer.this.take - aLong - Rx2Timer.this.resumeTake;
                }
            }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(@NonNull Long aLong) throws Exception {
                    if (Rx2Timer.this.onCount != null) {
                        Rx2Timer.this.onCount.onCount(aLong);
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(@NonNull Throwable throwable) throws Exception {
                    Rx2Timer.this.cleanPauseState();
                    if (Rx2Timer.this.onError != null) {
                        Rx2Timer.this.onError.onError(throwable);
                    }
                }
            }, new Action(){

                public void run() throws Exception {
                    Rx2Timer.this.cleanPauseState();
                    if (Rx2Timer.this.onComplete != null) {
                        Rx2Timer.this.onComplete.onComplete();
                    }
                }
            });
        }
    }

    public void cleanPauseState() {
        this.isPause = false;
        this.resumeTake = 0L;
        this.pauseTake = 0L;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface OnError {
        public void onError(Throwable var1);
    }

    public static interface OnCount {
        public void onCount(Long var1);
    }

    public static interface OnComplete {
        public void onComplete();
    }

    public static final class Builder {
        private long take = 60L;
        private long period = 1L;
        private long initialDelay = 0L;
        private TimeUnit unit = TimeUnit.SECONDS;
        private OnComplete onComplete;
        private OnCount onCount;
        private OnError onError;

        Builder() {
        }

        public Builder take(int take) {
            this.take = take;
            return this;
        }

        public Builder period(int period) {
            this.period = period;
            return this;
        }

        public Builder initialDelay(int initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder unit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder onComplete(OnComplete onComplete) {
            this.onComplete = onComplete;
            return this;
        }

        public Builder onCount(OnCount onCount) {
            this.onCount = onCount;
            return this;
        }

        public Builder onError(OnError onError) {
            this.onError = onError;
            return this;
        }

        public Rx2Timer build() {
            return new Rx2Timer(this);
        }
    }
}

