/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.service;

import com.github.tobato.fastdfs.domain.MataData;
import com.github.tobato.fastdfs.domain.StorageNode;
import com.github.tobato.fastdfs.domain.StorePath;
import com.github.tobato.fastdfs.domain.ThumbImageConfig;
import com.github.tobato.fastdfs.exception.FdfsUnsupportImageTypeException;
import com.github.tobato.fastdfs.exception.FdfsUploadImageException;
import com.github.tobato.fastdfs.proto.storage.StorageSetMetadataCommand;
import com.github.tobato.fastdfs.proto.storage.StorageUploadFileCommand;
import com.github.tobato.fastdfs.proto.storage.StorageUploadSlaveFileCommand;
import com.github.tobato.fastdfs.proto.storage.enums.StorageMetdataSetType;
import com.github.tobato.fastdfs.service.DefaultGenerateStorageClient;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultFastFileStorageClient
extends DefaultGenerateStorageClient
implements FastFileStorageClient {
    private static final String[] SUPPORT_IMAGE_TYPE = new String[]{"JPG", "JPEG", "PNG", "GIF", "BMP", "WBMP"};
    private static final List<String> SUPPORT_IMAGE_LIST = Arrays.asList(SUPPORT_IMAGE_TYPE);
    @Autowired
    private ThumbImageConfig thumbImageConfig;

    @Override
    public StorePath uploadFile(InputStream inputStream, long fileSize, String fileExtName, Set<MataData> metaDataSet) {
        Validate.notNull((Object)inputStream, (String)"\u4e0a\u4f20\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileExtName, (String)"\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StorageNode client = this.trackerClient.getStoreStorage();
        return this.uploadFileAndMataData(client, inputStream, fileSize, fileExtName, metaDataSet);
    }

    @Override
    public StorePath uploadImageAndCrtThumbImage(InputStream inputStream, long fileSize, String fileExtName, Set<MataData> metaDataSet) {
        Validate.notNull((Object)inputStream, (String)"\u4e0a\u4f20\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileExtName, (String)"\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!this.isSupportImage(fileExtName)) {
            throw new FdfsUnsupportImageTypeException("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f" + fileExtName);
        }
        StorageNode client = this.trackerClient.getStoreStorage();
        byte[] bytes = this.inputStreamToByte(inputStream);
        StorePath path = this.uploadFileAndMataData(client, new ByteArrayInputStream(bytes), fileSize, fileExtName, metaDataSet);
        this.uploadThumbImage(client, new ByteArrayInputStream(bytes), path.getPath(), fileExtName);
        bytes = null;
        return path;
    }

    private byte[] inputStreamToByte(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            LOGGER.error("image inputStream to byte error", (Throwable)e);
            throw new FdfsUploadImageException("upload ThumbImage error", e.getCause());
        }
    }

    private boolean hasMataData(Set<MataData> metaDataSet) {
        return null != metaDataSet && !metaDataSet.isEmpty();
    }

    private boolean isSupportImage(String fileExtName) {
        return SUPPORT_IMAGE_LIST.contains(fileExtName.toUpperCase());
    }

    private StorePath uploadFileAndMataData(StorageNode client, InputStream inputStream, long fileSize, String fileExtName, Set<MataData> metaDataSet) {
        StorageUploadFileCommand command = new StorageUploadFileCommand(client.getStoreIndex(), inputStream, fileExtName, fileSize, false);
        StorePath path = this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
        if (this.hasMataData(metaDataSet)) {
            StorageSetMetadataCommand setMDCommand = new StorageSetMetadataCommand(path.getGroup(), path.getPath(), metaDataSet, StorageMetdataSetType.STORAGE_SET_METADATA_FLAG_OVERWRITE);
            this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), setMDCommand);
        }
        return path;
    }

    private void uploadThumbImage(StorageNode client, InputStream inputStream, String masterFilename, String fileExtName) {
        ByteArrayInputStream thumbImageStream = null;
        try {
            thumbImageStream = this.getThumbImageStream(inputStream);
            long fileSize = thumbImageStream.available();
            String prefixName = this.thumbImageConfig.getPrefixName();
            StorageUploadSlaveFileCommand command = new StorageUploadSlaveFileCommand(thumbImageStream, fileSize, masterFilename, prefixName, fileExtName);
            this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
        }
        catch (IOException e) {
            LOGGER.error("upload ThumbImage error", (Throwable)e);
            throw new FdfsUploadImageException("upload ThumbImage error", e.getCause());
        }
        finally {
            IOUtils.closeQuietly((InputStream)thumbImageStream);
        }
    }

    private ByteArrayInputStream getThumbImageStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(this.thumbImageConfig.getWidth(), this.thumbImageConfig.getHeight()).toOutputStream((OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public void deleteFile(String filePath) {
        StorePath storePath = StorePath.praseFromUrl(filePath);
        super.deleteFile(storePath.getGroup(), storePath.getPath());
    }
}

