/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core.executor;

import cn.hutool.core.collection.CollectionUtil;
import com.github.xiaoymin.knife4j.aggre.core.RouteExecutor;
import com.github.xiaoymin.knife4j.aggre.core.RouteRequestContext;
import com.github.xiaoymin.knife4j.aggre.core.RouteResponse;
import com.github.xiaoymin.knife4j.aggre.core.executor.ApacheClientResponse;
import com.github.xiaoymin.knife4j.aggre.core.executor.DefaultClientResponse;
import com.github.xiaoymin.knife4j.aggre.core.ext.PoolingConnectionManager;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheClientExecutor
extends PoolingConnectionManager
implements RouteExecutor {
    Logger logger = LoggerFactory.getLogger(ApacheClientExecutor.class);

    private HttpUriRequest buildRequest(RouteRequestContext routeContext) {
        RequestBuilder builder = RequestBuilder.create((String)routeContext.getMethod());
        this.logger.info("ApacheClient Uri:{}", (Object)routeContext.getUrl());
        builder.setUri(routeContext.getUrl());
        if (CollectionUtil.isNotEmpty(routeContext.getHeaders())) {
            for (Map.Entry<String, String> entry : routeContext.getHeaders().entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (CollectionUtil.isNotEmpty(routeContext.getParams())) {
            for (Map.Entry<String, String> entry : routeContext.getParams().entrySet()) {
                builder.addParameter(entry.getKey(), entry.getValue());
            }
        }
        if (routeContext.getRequestContent() != null) {
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
            basicHttpEntity.setContent(routeContext.getRequestContent());
            builder.setEntity((HttpEntity)basicHttpEntity);
        }
        builder.setConfig(this.getRequestConfig());
        return builder.build();
    }

    @Override
    public RouteResponse executor(RouteRequestContext routeContext) {
        RouteResponse routeResponse = null;
        try {
            CloseableHttpResponse closeableHttpResponse = this.getClient().execute(this.buildRequest(routeContext));
            routeResponse = new ApacheClientResponse((HttpResponse)closeableHttpResponse);
        }
        catch (Exception e) {
            this.logger.error("Executor Failed,message:{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            routeResponse = new DefaultClientResponse(routeContext.getOriginalUri(), e.getMessage());
        }
        return routeResponse;
    }
}

