/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core.filter;

import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.RouteDispatcher;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Knife4jRouteProxyFilter
implements Filter {
    private final RouteDispatcher routeDispatcher;
    private final Gson gson = new GsonBuilder().create();
    Logger logger = LoggerFactory.getLogger(Knife4jRouteProxyFilter.class);

    public Knife4jRouteProxyFilter(RouteDispatcher routeDispatcher) {
        this.routeDispatcher = routeDispatcher;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        if (this.routeDispatcher.checkRoute(request.getHeader("knfie4j-gateway-request"))) {
            this.logger.info("Current Request:{}", (Object)uri);
            this.logger.info("\u5f53\u524d\u8bf7\u6c42\u662fProxy\u8bf7\u6c42");
            this.routeDispatcher.execute(request, response);
            this.logger.info("\u6267\u884c\u5b8c\u6bd5");
        } else if (StrUtil.endWith((CharSequence)uri, (CharSequence)"/swagger-resources")) {
            this.writeRouteResponse(response, this.gson.toJson(this.routeDispatcher.getRoutes()));
        } else if (StrUtil.endWith((CharSequence)uri, (CharSequence)"/swagger-instance")) {
            String group = request.getParameter("group");
            SwaggerRoute swaggerRoute = this.routeDispatcher.getRoute(group);
            this.writeRouteResponse(response, swaggerRoute == null ? "" : swaggerRoute.getContent());
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected void writeRouteResponse(HttpServletResponse response, String content) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter printWriter = response.getWriter();
        printWriter.write(content);
        printWriter.close();
    }

    public void destroy() {
    }
}

