/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.github.xiaoymin.knife4j.aggre.cloud.CloudRoute;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.repository.AbsctractRepository;
import com.github.xiaoymin.knife4j.aggre.spring.support.CloudSetting;

public class CloudRepository
extends AbsctractRepository {
    private CloudSetting cloudSetting;

    public CloudRepository(CloudSetting cloudSetting) {
        this.cloudSetting = cloudSetting;
        if (cloudSetting != null && CollectionUtil.isNotEmpty(cloudSetting.getRoutes())) {
            cloudSetting.getRoutes().stream().forEach(cloudRoute -> {
                if (cloudRoute.getRouteAuth() == null || !cloudRoute.getRouteAuth().isEnable()) {
                    cloudRoute.setRouteAuth(cloudSetting.getRouteAuth());
                }
                this.routeMap.put(cloudRoute.pkId(), new SwaggerRoute((CloudRoute)cloudRoute));
            });
        }
    }

    @Override
    public BasicAuth getAuth(String header) {
        BasicAuth basicAuth = null;
        if (this.cloudSetting != null && CollectionUtil.isNotEmpty(this.cloudSetting.getRoutes())) {
            if (this.cloudSetting.getRouteAuth() != null && this.cloudSetting.getRouteAuth().isEnable()) {
                basicAuth = this.cloudSetting.getRouteAuth();
                BasicAuth routeBasicAuth = this.getAuthByRoute(header, this.cloudSetting.getRoutes());
                if (routeBasicAuth != null) {
                    basicAuth = routeBasicAuth;
                }
            } else {
                basicAuth = this.getAuthByRoute(header, this.cloudSetting.getRoutes());
            }
        }
        return basicAuth;
    }

    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }
}

