/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.repository;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosInstance;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosRoute;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosService;
import com.github.xiaoymin.knife4j.aggre.repository.AbsctractRepository;
import com.github.xiaoymin.knife4j.aggre.spring.support.NacosSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRepository
extends AbsctractRepository {
    Logger logger = LoggerFactory.getLogger(NacosRepository.class);
    private NacosSetting nacosSetting;
    final ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)5, (int)5);
    private Map<String, NacosInstance> nacosInstanceMap = new HashMap<String, NacosInstance>();

    public NacosRepository(NacosSetting nacosSetting) {
        this.nacosSetting = nacosSetting;
        if (nacosSetting != null && CollectionUtil.isNotEmpty(nacosSetting.getRoutes())) {
            this.initNacos(nacosSetting);
            this.applyRoutes(nacosSetting);
        }
    }

    private void applyRoutes(NacosSetting nacosSetting) {
        if (CollectionUtil.isNotEmpty(this.nacosInstanceMap)) {
            nacosSetting.getRoutes().forEach(nacosRoute -> {
                if (nacosRoute.getRouteAuth() == null || !nacosRoute.getRouteAuth().isEnable()) {
                    nacosRoute.setRouteAuth(nacosSetting.getRouteAuth());
                }
                this.routeMap.put(nacosRoute.pkId(), new SwaggerRoute((NacosRoute)nacosRoute, this.nacosInstanceMap.get(nacosRoute.getServiceName())));
            });
            nacosSetting.getRoutes().forEach(nacosRoute -> this.routeMap.put(nacosRoute.pkId(), new SwaggerRoute((NacosRoute)nacosRoute, this.nacosInstanceMap.get(nacosRoute.getServiceName()))));
        }
    }

    public void initNacos(NacosSetting nacosSetting) {
        ArrayList optionalList = new ArrayList();
        nacosSetting.getRoutes().forEach(nacosRoute -> optionalList.add(this.threadPoolExecutor.submit(new NacosService(nacosSetting.getServiceUrl(), nacosSetting.getSecret(), (NacosRoute)nacosRoute))));
        optionalList.stream().forEach(optionalFuture -> {
            try {
                Optional nacosInstanceOptional = (Optional)optionalFuture.get();
                if (nacosInstanceOptional.isPresent()) {
                    this.nacosInstanceMap.put(((NacosInstance)nacosInstanceOptional.get()).getServiceName(), (NacosInstance)nacosInstanceOptional.get());
                }
            }
            catch (Exception e) {
                this.logger.error("nacos get error:" + e.getMessage(), (Throwable)e);
            }
        });
    }

    public NacosSetting getNacosSetting() {
        return this.nacosSetting;
    }

    @Override
    public BasicAuth getAuth(String header) {
        BasicAuth basicAuth = null;
        if (this.nacosSetting != null && CollectionUtil.isNotEmpty(this.nacosSetting.getRoutes())) {
            if (this.nacosSetting.getRouteAuth() != null && this.nacosSetting.getRouteAuth().isEnable()) {
                basicAuth = this.nacosSetting.getRouteAuth();
                BasicAuth routeBasicAuth = this.getAuthByRoute(header, this.nacosSetting.getRoutes());
                if (routeBasicAuth != null) {
                    basicAuth = routeBasicAuth;
                }
            } else {
                basicAuth = this.getAuthByRoute(header, this.nacosSetting.getRoutes());
            }
        }
        return basicAuth;
    }
}

