/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.spring.configuration;

import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.RouteCache;
import com.github.xiaoymin.knife4j.aggre.core.RouteDispatcher;
import com.github.xiaoymin.knife4j.aggre.core.RouteRepository;
import com.github.xiaoymin.knife4j.aggre.core.cache.RouteInMemoryCache;
import com.github.xiaoymin.knife4j.aggre.core.common.ExecutorEnum;
import com.github.xiaoymin.knife4j.aggre.core.filter.Knife4jRouteProxyFilter;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.repository.CloudRepository;
import com.github.xiaoymin.knife4j.aggre.repository.DiskRepository;
import com.github.xiaoymin.knife4j.aggre.repository.EurekaRepository;
import com.github.xiaoymin.knife4j.aggre.repository.NacosRepository;
import com.github.xiaoymin.knife4j.aggre.spring.configuration.Knife4jAggregationProperties;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={Knife4jAggregationProperties.class})
@ConditionalOnProperty(name={"knife4j.enableAggregation"}, havingValue="true")
public class Knife4jAggregationAutoConfiguration {
    final Environment environment;

    @Autowired
    public Knife4jAggregationAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    public RouteCache<String, SwaggerRoute> routeCache() {
        return new RouteInMemoryCache();
    }

    @Bean
    @ConditionalOnProperty(name={"knife4j.cloud.enable"}, havingValue="true")
    public CloudRepository cloudRepository(@Autowired Knife4jAggregationProperties knife4jAggregationProperties) {
        return new CloudRepository(knife4jAggregationProperties.getCloud());
    }

    @Bean
    @ConditionalOnProperty(name={"knife4j.eureka.enable"}, havingValue="true")
    public EurekaRepository eurekaRepository(@Autowired Knife4jAggregationProperties knife4jAggregationProperties) {
        return new EurekaRepository(knife4jAggregationProperties.getEureka());
    }

    @Bean
    @ConditionalOnProperty(name={"knife4j.nacos.enable"}, havingValue="true")
    public NacosRepository nacosRepository(@Autowired Knife4jAggregationProperties knife4jAggregationProperties) {
        return new NacosRepository(knife4jAggregationProperties.getNacos());
    }

    @Bean
    @ConditionalOnProperty(name={"knife4j.disk.enable"}, havingValue="true")
    public DiskRepository diskRepository(@Autowired Knife4jAggregationProperties knife4jAggregationProperties) {
        return new DiskRepository(knife4jAggregationProperties.getDisk());
    }

    @Bean
    public RouteDispatcher routeDispatcher(@Autowired RouteRepository routeRepository, @Autowired RouteCache<String, SwaggerRoute> routeCache) {
        String contextPath = this.environment.getProperty("server.servlet.context-path");
        if (StrUtil.isBlank((CharSequence)contextPath)) {
            contextPath = "/";
        }
        if (StrUtil.isNotBlank((CharSequence)contextPath) && !StrUtil.equals((CharSequence)contextPath, (CharSequence)"/") && !StrUtil.startWith((CharSequence)contextPath, (CharSequence)"/")) {
            contextPath = "/" + contextPath;
        }
        return new RouteDispatcher(routeRepository, routeCache, ExecutorEnum.APACHE, contextPath);
    }

    @Bean
    public FilterRegistrationBean routeProxyFilter(@Autowired RouteDispatcher routeDispatcher) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new Knife4jRouteProxyFilter(routeDispatcher));
        filterRegistrationBean.setOrder(99);
        filterRegistrationBean.setEnabled(true);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        return filterRegistrationBean;
    }
}

