/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache.repository;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.zuihou.cache.repository.CacheRepository;
import java.time.Duration;
import java.util.function.Function;

public class CaffeineRepositoryImpl
implements CacheRepository {
    long DEF_MAX_SIZE = 1000L;
    private final Cache<String, Cache<String, Object>> cacheMap = Caffeine.newBuilder().maximumSize(this.DEF_MAX_SIZE).build();

    @Override
    public void setExpire(String key, Object value, long time) {
        Cache cache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(time)).maximumSize(this.DEF_MAX_SIZE).build();
        cache.put((Object)key, value);
        this.cacheMap.put((Object)key, (Object)cache);
    }

    @Override
    public void set(String key, Object value) {
        Cache cache = Caffeine.newBuilder().maximumSize(this.DEF_MAX_SIZE).build();
        cache.put((Object)key, value);
        this.cacheMap.put((Object)key, (Object)cache);
    }

    @Override
    public <T> T get(String key) {
        Cache ifPresent = (Cache)this.cacheMap.getIfPresent((Object)key);
        if (ifPresent == null) {
            return null;
        }
        return (T)ifPresent.getIfPresent((Object)key);
    }

    @Override
    public <T> T getOrDef(String key, Function<String, ? extends T> function) {
        Cache cache = (Cache)this.cacheMap.get((Object)key, k -> {
            Cache newCache = Caffeine.newBuilder().maximumSize(this.DEF_MAX_SIZE).build();
            newCache.get(k, function);
            return newCache;
        });
        return (T)cache.getIfPresent((Object)key);
    }

    @Override
    public void flushDb() {
        this.cacheMap.invalidateAll();
    }

    @Override
    public boolean exists(String key) {
        Cache cache = (Cache)this.cacheMap.getIfPresent((Object)key);
        if (cache == null) {
            return false;
        }
        cache.cleanUp();
        return cache.estimatedSize() > 0L;
    }

    @Override
    public long del(String ... keys) {
        for (String key : keys) {
            this.cacheMap.invalidate((Object)key);
        }
        return keys.length;
    }
}

