/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.injection;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zuihou.injection.aspect.InjectionResultAspect;
import com.github.zuihou.injection.configuration.InjectionProperties;
import com.github.zuihou.injection.core.InjectionCore;
import com.github.zuihou.injection.mybatis.typehandler.RemoteDataTypeHandler;
import com.github.zuihou.utils.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={InjectionProperties.class})
@ConditionalOnProperty(name={"zuihou.injection.enabled"}, havingValue="true", matchIfMissing=true)
public class InjectionDataAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(InjectionDataAutoConfiguration.class);
    private InjectionProperties remoteProperties;

    @Bean
    @ConditionalOnMissingBean
    public SpringUtils beanFactoryUtils() {
        return new SpringUtils();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"zuihou.injection.aop-enabled"}, havingValue="true", matchIfMissing=true)
    public InjectionResultAspect getRemoteAspect(InjectionCore injectionCore) {
        return new InjectionResultAspect(injectionCore);
    }

    @Bean
    @ConditionalOnMissingBean
    public InjectionCore getInjectionCore(ObjectMapper mapper) {
        return new InjectionCore(mapper, this.remoteProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public RemoteDataTypeHandler getRemoteDataTypeHandler() {
        return new RemoteDataTypeHandler();
    }

    public InjectionDataAutoConfiguration(InjectionProperties remoteProperties) {
        this.remoteProperties = remoteProperties;
    }
}

