/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.injection.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.injection.annonation.InjectionField;
import com.github.zuihou.injection.annonation.InjectionResult;
import com.github.zuihou.injection.configuration.InjectionProperties;
import com.github.zuihou.injection.core.InjectionFieldExtPo;
import com.github.zuihou.injection.core.InjectionFieldPo;
import com.github.zuihou.model.RemoteData;
import com.github.zuihou.utils.SpringUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionCore {
    private static final Logger log = LoggerFactory.getLogger(InjectionCore.class);
    private static int MAX_DEPTH = 2;
    private final InjectionProperties ips;
    private final ObjectMapper mapper;
    private ListeningExecutorService backgroundRefreshPools;
    private LoadingCache<InjectionFieldExtPo, Map<Serializable, Object>> caches;

    public InjectionCore(ObjectMapper mapper, InjectionProperties ips) {
        this.ips = ips;
        this.mapper = mapper;
        InjectionProperties.GuavaCache guavaCache = ips.getGuavaCache();
        if (guavaCache.getEnabled().booleanValue()) {
            this.backgroundRefreshPools = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(guavaCache.getRefreshThreadPoolSize(), guavaCache.getRefreshThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
            this.caches = CacheBuilder.newBuilder().maximumSize((long)guavaCache.getMaximumSize().intValue()).refreshAfterWrite((long)guavaCache.getRefreshWriteTime().intValue(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<InjectionFieldExtPo, Map<Serializable, Object>>(){

                public Map<Serializable, Object> load(InjectionFieldExtPo type) throws Exception {
                    log.info("\u9996\u6b21\u8bfb\u53d6\u7f13\u5b58: " + type);
                    return InjectionCore.this.loadMap(type);
                }

                public ListenableFuture<Map<Serializable, Object>> reload(InjectionFieldExtPo key, Map<Serializable, Object> oldValue) throws Exception {
                    return InjectionCore.this.backgroundRefreshPools.submit(() -> {
                        BaseContextHandler.setTenant((String)key.getTenant());
                        return this.load(key);
                    });
                }
            });
        }
    }

    private Map<Serializable, Object> loadMap(InjectionFieldExtPo type) {
        Object bean = null;
        if (StrUtil.isNotEmpty((CharSequence)type.getApi())) {
            bean = SpringUtils.getBean((String)type.getApi());
            log.info("\u5efa\u8bae\u5728\u65b9\u6cd5\uff1a [{}.{}]\uff0c\u4e0a\u52a0\u5165\u7f13\u5b58\uff0c\u52a0\u901f\u67e5\u8be2", (Object)type.getApi(), (Object)type.getMethod());
        } else {
            bean = SpringUtils.getBean(type.getFeign());
            log.info("\u5efa\u8bae\u5728\u65b9\u6cd5\uff1a [{}.{}]\uff0c\u4e0a\u52a0\u5165\u7f13\u5b58\uff0c\u52a0\u901f\u67e5\u8be2", (Object)type.getFeign().toString(), (Object)type.getMethod());
        }
        Map value = (Map)ReflectUtil.invoke((Object)bean, (String)type.getMethod(), (Object[])new Object[]{type.getKeys()});
        return value;
    }

    public void injection(Object obj, boolean isUseCache) {
        try {
            HashMap<InjectionFieldPo, Map<Serializable, Object>> typeMap = new HashMap<InjectionFieldPo, Map<Serializable, Object>>();
            long parseStart = System.currentTimeMillis();
            this.parse(obj, typeMap, 1, MAX_DEPTH);
            long parseEnd = System.currentTimeMillis();
            log.info("\u89e3\u6790\u8017\u65f6={} ms", (Object)(parseEnd - parseStart));
            if (typeMap.isEmpty()) {
                return;
            }
            for (Map.Entry entries : typeMap.entrySet()) {
                InjectionFieldPo type = (InjectionFieldPo)entries.getKey();
                Map valueMap = (Map)entries.getValue();
                Set<Serializable> keys = valueMap.keySet();
                try {
                    InjectionFieldExtPo extPo = new InjectionFieldExtPo(type, keys);
                    Map value = this.ips.getGuavaCache().getEnabled() != false && isUseCache ? (Map)this.caches.get((Object)extPo) : this.loadMap(extPo);
                    typeMap.put(type, value);
                }
                catch (Exception e) {
                    log.error("\u8fdc\u7a0b\u8c03\u7528\u65b9\u6cd5 [{}({}).{}] \u5931\u8d25\uff0c \u8bf7\u786e\u4fdd\u7cfb\u7edf\u5b58\u5728\u8be5\u65b9\u6cd5", new Object[]{type.getApi(), type.getFeign().toString(), type.getMethod(), e});
                }
            }
            long injectionStart = System.currentTimeMillis();
            log.info("\u6279\u91cf\u67e5\u8be2\u8017\u65f6={} ms", (Object)(injectionStart - parseEnd));
            this.injection(obj, typeMap, 1, MAX_DEPTH);
            long injectionEnd = System.currentTimeMillis();
            log.info("\u6ce8\u5165\u8017\u65f6={} ms", (Object)(injectionEnd - injectionStart));
        }
        catch (Exception e) {
            log.warn("\u6ce8\u5165\u5931\u8d25", (Throwable)e);
        }
    }

    public void injection(Object obj) {
        this.injection(obj, true);
    }

    public Object injection(ProceedingJoinPoint pjp, InjectionResult anno) throws Throwable {
        Object proceed = pjp.proceed();
        try {
            this.injection(proceed);
            return proceed;
        }
        catch (Exception e) {
            log.error("\u67d0\u5c5e\u6027\u6570\u636e\u805a\u5408\u5931\u8d25", (Throwable)e);
            return proceed;
        }
    }

    private boolean isNotBaseType(Object obj, Field field) {
        String typeName = field.getType().getName();
        return !"java.lang.Integer".equals(typeName) && !"java.lang.Byte".equals(typeName) && !"java.lang.Long".equals(typeName) && !"java.lang.Double".equals(typeName) && !"java.lang.Float".equals(typeName) && !"java.lang.Character".equals(typeName) && !"java.lang.Short".equals(typeName) && !"java.lang.Boolean".equals(typeName) && !"java.lang.String".equals(typeName) && !"com.github.zuihou.model.RemoteData".equals(typeName);
    }

    private void parse(Object obj, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, int depth, int maxDepth) throws Exception {
        Field[] fields;
        if (obj == null) {
            return;
        }
        if (depth > maxDepth) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u5bf9\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)depth, (Object)maxDepth);
            return;
        }
        if (typeMap == null) {
            typeMap = new HashMap<InjectionFieldPo, Map<Serializable, Object>>();
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.parseList(records, typeMap, depth, maxDepth);
            return;
        }
        if (obj instanceof Collection) {
            this.parseList((Collection)obj, typeMap, depth, maxDepth);
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(obj.getClass())) {
            Object queryKey;
            InjectionField anno = field.getDeclaredAnnotation(InjectionField.class);
            if (anno == null) continue;
            field.setAccessible(true);
            if (this.isNotBaseType(obj, field)) {
                this.parse(field.get(obj), typeMap, depth + 1, anno.depth());
                continue;
            }
            String api = anno.api();
            Class<? extends Object> feign = anno.feign();
            if (StrUtil.isEmpty((CharSequence)api) && Object.class.equals(feign)) {
                log.warn("\u5ffd\u7565\u89e3\u6790\u5b57\u6bb5: {}.{}", field.getType(), (Object)field.getName());
                continue;
            }
            String key = anno.key();
            InjectionFieldPo type = new InjectionFieldPo(anno);
            Map<Object, Object> valueMap = typeMap.get(type) == null ? new HashMap() : typeMap.get(type);
            if (StrUtil.isNotEmpty((CharSequence)key)) {
                queryKey = key;
            } else {
                try {
                    Object curField = ReflectUtil.getFieldValue((Object)obj, (Field)field);
                    if (curField instanceof RemoteData) {
                        RemoteData remoteData = (RemoteData)curField;
                        queryKey = (Serializable)remoteData.getKey();
                    } else {
                        queryKey = (Serializable)curField;
                    }
                }
                catch (Exception e) {
                    log.warn("\u7c7b\u578b\u88c5\u6362\u5931\u8d25\u5ffd\u7565\u6ce8\u5165\u5b57\u6bb5: {}.{}", field.getType(), (Object)field.getName());
                    continue;
                }
            }
            if (ObjectUtil.isNotEmpty((Object)queryKey)) {
                valueMap.put(queryKey, null);
            }
            typeMap.put(type, valueMap);
        }
    }

    private void parseList(Collection list, Map typeMap, int depth, int maxDepth) throws Exception {
        for (Object item : list) {
            this.parse(item, typeMap, depth, maxDepth);
        }
    }

    private void injection(Object obj, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, int depth, int maxDepth) throws Exception {
        Field[] fields;
        if (obj == null) {
            return;
        }
        if (depth > maxDepth) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u5bf9\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)depth, (Object)maxDepth);
            return;
        }
        if (typeMap == null || typeMap.isEmpty()) {
            return;
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.injectionList(records, typeMap);
            return;
        }
        if (obj instanceof Collection) {
            this.injectionList((Collection)obj, typeMap);
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(obj.getClass())) {
            InjectionField anno = field.getDeclaredAnnotation(InjectionField.class);
            if (anno == null) continue;
            field.setAccessible(true);
            if (this.isNotBaseType(obj, field)) {
                this.injection(field.get(obj), typeMap, depth + 1, anno.depth());
                continue;
            }
            String api = anno.api();
            Class<? extends Object> feign = anno.feign();
            if (StrUtil.isEmpty((CharSequence)api) && Object.class.equals(feign)) {
                log.warn("\u5ffd\u7565\u6ce8\u5165\u5b57\u6bb5: {}.{}", field.getType(), (Object)field.getName());
                continue;
            }
            String key = anno.key();
            InjectionFieldPo type = new InjectionFieldPo(anno);
            Object queryKey = null;
            if (StrUtil.isNotEmpty((CharSequence)key)) {
                queryKey = key;
            } else {
                Object curField = ReflectUtil.getFieldValue((Object)obj, (Field)field);
                if (curField instanceof RemoteData) {
                    RemoteData remoteData = (RemoteData)curField;
                    queryKey = (Serializable)remoteData.getKey();
                } else {
                    queryKey = (Serializable)curField;
                }
            }
            Map<Serializable, Object> valueMap = typeMap.get(type);
            if (valueMap == null || valueMap.isEmpty()) continue;
            Object curField = ReflectUtil.getFieldValue((Object)obj, (Field)field);
            if (curField == null) {
                log.debug("\u5b57\u6bb5[{}]\u4e3a\u7a7a,\u8df3\u8fc7", (Object)field.getName());
                continue;
            }
            Object newVal = valueMap.get(queryKey);
            if (ObjectUtil.isNull((Object)newVal) && ObjectUtil.isNotEmpty((Object)queryKey)) {
                newVal = valueMap.get(queryKey.toString());
            }
            if (curField instanceof RemoteData) {
                RemoteData remoteData = (RemoteData)curField;
                if (newVal != null && newVal instanceof Map && !Object.class.equals(type.getBeanClass())) {
                    String s = this.mapper.writeValueAsString(newVal);
                    newVal = this.mapper.readValue(s, type.getBeanClass());
                }
                remoteData.setData(newVal);
                continue;
            }
            ReflectUtil.setFieldValue((Object)obj, (Field)field, (Object)newVal);
        }
    }

    private void injectionList(Collection list, Map typeMap) throws Exception {
        for (Object item : list) {
            this.injection(item, typeMap, 1, MAX_DEPTH);
        }
    }
}

