/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.picker;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.zyyoona7.picker.R;
import com.zyyoona7.picker.base.BaseDatePickerView;
import com.zyyoona7.wheel.WheelView;

public class DatePickerView
extends BaseDatePickerView {
    private AppCompatTextView mYearTv;
    private AppCompatTextView mMonthTv;
    private AppCompatTextView mDayTv;

    public DatePickerView(Context context) {
        this(context, null);
    }

    public DatePickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DatePickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mYearTv = (AppCompatTextView)this.findViewById(R.id.tv_year);
        this.mMonthTv = (AppCompatTextView)this.findViewById(R.id.tv_month);
        this.mDayTv = (AppCompatTextView)this.findViewById(R.id.tv_day);
    }

    @Override
    protected int getDatePickerViewLayoutId() {
        return R.layout.layout_date_picker_view;
    }

    @Override
    protected int getYearWheelViewId() {
        return R.id.wv_year;
    }

    @Override
    protected int getMonthWheelViewId() {
        return R.id.wv_month;
    }

    @Override
    protected int getDayWheelViewId() {
        return R.id.wv_day;
    }

    public void setLabelTextSize(float textSize) {
        this.mYearTv.setTextSize(textSize);
        this.mMonthTv.setTextSize(textSize);
        this.mDayTv.setTextSize(textSize);
    }

    public void setLabelTextSize(int unit, float textSize) {
        this.mYearTv.setTextSize(unit, textSize);
        this.mMonthTv.setTextSize(unit, textSize);
        this.mDayTv.setTextSize(unit, textSize);
    }

    public void setLabelTextColorRes(@ColorRes int textColorRes) {
        this.setLabelTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public void setLabelTextColor(@ColorInt int textColor) {
        this.mYearTv.setTextColor(textColor);
        this.mMonthTv.setTextColor(textColor);
        this.mDayTv.setTextColor(textColor);
    }

    public void setShowLabel(boolean isShowLabel) {
        if (isShowLabel) {
            this.setLabelVisibility(0);
        } else {
            this.setLabelVisibility(8);
        }
    }

    private void setLabelVisibility(int visibility) {
        this.mYearTv.setVisibility(visibility);
        this.mMonthTv.setVisibility(visibility);
        this.mDayTv.setVisibility(visibility);
    }

    public void hideDayItem() {
        this.setItemVisibility(8, this.mDayWv, this.mDayTv);
    }

    public void showDayItem() {
        this.setItemVisibility(0, this.mDayWv, this.mDayTv);
    }

    public void hideMonthItem() {
        this.setItemVisibility(8, this.mMonthWv, this.mMonthTv);
    }

    public void showMonthItem() {
        this.setItemVisibility(0, this.mMonthWv, this.mMonthTv);
    }

    public void hideYearItem() {
        this.setItemVisibility(8, this.mYearWv, this.mYearTv);
    }

    public void showYearItem() {
        this.setItemVisibility(0, this.mYearWv, this.mYearTv);
    }

    private void setItemVisibility(int visibility, WheelView wheelView, AppCompatTextView textView) {
        if (wheelView != null) {
            wheelView.setVisibility(visibility);
        }
        if (textView != null) {
            textView.setVisibility(visibility);
        }
    }

    public void setYearRange(int start, int end) {
        this.mYearWv.setYearRange(start, end);
    }

    public int getSelectedYear() {
        return this.mYearWv.getSelectedYear();
    }

    public void setSelectedYear(int year) {
        this.setSelectedYear(year, false);
    }

    public void setSelectedYear(int year, boolean isSmoothScroll) {
        this.setSelectedYear(year, isSmoothScroll, 0);
    }

    public void setSelectedYear(int year, boolean isSmoothScroll, int smoothDuration) {
        this.mYearWv.setSelectedYear(year, isSmoothScroll, smoothDuration);
    }

    public int getSelectedMonth() {
        return this.mMonthWv.getSelectedMonth();
    }

    public void setSelectedMonth(int month) {
        this.mMonthWv.setSelectedMonth(month, false);
    }

    public void setSelectedMonth(int month, boolean isSmoothScroll) {
        this.mMonthWv.setSelectedMonth(month, isSmoothScroll, 0);
    }

    public void setSelectedMonth(int month, boolean isSmoothScroll, int smoothDuration) {
        this.mMonthWv.setSelectedMonth(month, isSmoothScroll, smoothDuration);
    }

    public int getSelectedDay() {
        return this.mDayWv.getSelectedDay();
    }

    public void setSelectedDay(int day) {
        this.mDayWv.setSelectedDay(day, false);
    }

    public void setSelectedDay(int day, boolean isSmoothScroll) {
        this.mDayWv.setSelectedDay(day, isSmoothScroll, 0);
    }

    public void setSelectedDay(int day, boolean isSmoothScroll, int smoothDuration) {
        this.mDayWv.setSelectedDay(day, isSmoothScroll, smoothDuration);
    }

    public String getSelectedDate() {
        return this.getSelectedYear() + "-" + this.getSelectedMonth() + "-" + this.getSelectedDay();
    }

    public void setResetSelectedPosition(boolean isResetSelectedPosition) {
        this.mYearWv.setResetSelectedPosition(isResetSelectedPosition);
        this.mMonthWv.setResetSelectedPosition(isResetSelectedPosition);
        this.mDayWv.setResetSelectedPosition(isResetSelectedPosition);
    }

    public void setVisibleItems(int visibleItems) {
        this.mYearWv.setVisibleItems(visibleItems);
        this.mMonthWv.setVisibleItems(visibleItems);
        this.mDayWv.setVisibleItems(visibleItems);
    }

    public void setAutoFitTextSize(boolean isAutoFitTextSize) {
        this.mYearWv.setAutoFitTextSize(isAutoFitTextSize);
        this.mMonthWv.setAutoFitTextSize(isAutoFitTextSize);
        this.mDayWv.setAutoFitTextSize(isAutoFitTextSize);
    }

    public void setTextSize(float textSize) {
        this.setTextSize(textSize, false);
    }

    public void setTextSize(float textSize, boolean isDp) {
        this.mYearWv.setTextSize(textSize, isDp);
        this.mMonthWv.setTextSize(textSize, isDp);
        this.mDayWv.setTextSize(textSize, isDp);
    }

    public void setTypeface(Typeface tf) {
        this.mYearWv.setTypeface(tf);
        this.mMonthWv.setTypeface(tf);
        this.mDayWv.setTypeface(tf);
    }

    public void setTextBoundaryMargin(float textBoundaryMargin, boolean isDp) {
        this.mYearWv.setTextBoundaryMargin(textBoundaryMargin, isDp);
        this.mMonthWv.setTextBoundaryMargin(textBoundaryMargin, isDp);
        this.mDayWv.setTextBoundaryMargin(textBoundaryMargin, isDp);
    }

    public void setNormalItemTextColorRes(@ColorRes int textColorRes) {
        this.setNormalItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public void setNormalItemTextColor(@ColorInt int textColor) {
        this.mYearWv.setNormalItemTextColor(textColor);
        this.mMonthWv.setNormalItemTextColor(textColor);
        this.mDayWv.setNormalItemTextColor(textColor);
    }

    public void setSelectedItemTextColorRes(@ColorRes int textColorRes) {
        this.setSelectedItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public void setSelectedItemTextColor(@ColorInt int textColor) {
        this.mYearWv.setSelectedItemTextColor(textColor);
        this.mMonthWv.setSelectedItemTextColor(textColor);
        this.mDayWv.setSelectedItemTextColor(textColor);
    }

    public void setCyclic(boolean isCyclic) {
        this.mYearWv.setCyclic(isCyclic);
        this.mMonthWv.setCyclic(isCyclic);
        this.mDayWv.setCyclic(isCyclic);
    }

    public void setLineSpacing(float lineSpacing) {
        this.setLineSpacing(lineSpacing, false);
    }

    public void setLineSpacing(float lineSpacing, boolean isDp) {
        this.mYearWv.setLineSpacing(lineSpacing, isDp);
        this.mMonthWv.setLineSpacing(lineSpacing, isDp);
        this.mDayWv.setLineSpacing(lineSpacing, isDp);
    }

    public void setSoundEffect(boolean isSoundEffect) {
        this.mYearWv.setSoundEffect(isSoundEffect);
        this.mMonthWv.setSoundEffect(isSoundEffect);
        this.mDayWv.setSoundEffect(isSoundEffect);
    }

    public void setSoundEffectResource(@RawRes int rawRes) {
        this.mYearWv.setSoundEffectResource(rawRes);
        this.mMonthWv.setSoundEffectResource(rawRes);
        this.mDayWv.setSoundEffectResource(rawRes);
    }

    public void setPlayVolume(@FloatRange(from=0.0, to=1.0) float playVolume) {
        this.mYearWv.setPlayVolume(playVolume);
        this.mMonthWv.setPlayVolume(playVolume);
        this.mDayWv.setPlayVolume(playVolume);
    }

    public void setShowDivider(boolean isShowDivider) {
        this.mYearWv.setShowDivider(isShowDivider);
        this.mMonthWv.setShowDivider(isShowDivider);
        this.mDayWv.setShowDivider(isShowDivider);
    }

    public void setDividerColorRes(@ColorRes int dividerColorRes) {
        this.setDividerColor(ContextCompat.getColor((Context)this.getContext(), (int)dividerColorRes));
    }

    public void setDividerColor(@ColorInt int dividerColor) {
        this.mYearWv.setDividerColor(dividerColor);
        this.mMonthWv.setDividerColor(dividerColor);
        this.mDayWv.setDividerColor(dividerColor);
    }

    public void setDividerHeight(float dividerHeight) {
        this.setDividerHeight(dividerHeight, false);
    }

    public void setDividerHeight(float dividerHeight, boolean isDp) {
        this.mYearWv.setDividerHeight(dividerHeight, isDp);
        this.mMonthWv.setDividerHeight(dividerHeight, isDp);
        this.mDayWv.setDividerHeight(dividerHeight, isDp);
    }

    public void setDividerType(int dividerType) {
        this.mYearWv.setDividerType(dividerType);
        this.mMonthWv.setDividerType(dividerType);
        this.mDayWv.setDividerType(dividerType);
    }

    public void setDividerPaddingForWrap(float dividerPaddingForWrap, boolean isDp) {
        this.mYearWv.setDividerPaddingForWrap(dividerPaddingForWrap, isDp);
        this.mMonthWv.setDividerPaddingForWrap(dividerPaddingForWrap, isDp);
        this.mDayWv.setDividerPaddingForWrap(dividerPaddingForWrap, isDp);
    }

    public void setDrawSelectedRect(boolean isDrawSelectedRect) {
        this.mYearWv.setDrawSelectedRect(isDrawSelectedRect);
        this.mMonthWv.setDrawSelectedRect(isDrawSelectedRect);
        this.mDayWv.setDrawSelectedRect(isDrawSelectedRect);
    }

    public void setSelectedRectColorRes(@ColorRes int selectedRectColorRes) {
        this.setSelectedRectColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedRectColorRes));
    }

    public void setSelectedRectColor(@ColorInt int selectedRectColor) {
        this.mYearWv.setSelectedRectColor(selectedRectColor);
        this.mMonthWv.setSelectedRectColor(selectedRectColor);
        this.mDayWv.setSelectedRectColor(selectedRectColor);
    }

    public void setCurved(boolean isCurved) {
        this.mYearWv.setCurved(isCurved);
        this.mMonthWv.setCurved(isCurved);
        this.mDayWv.setCurved(isCurved);
    }

    public void setCurvedArcDirection(int curvedArcDirection) {
        this.mYearWv.setCurvedArcDirection(curvedArcDirection);
        this.mMonthWv.setCurvedArcDirection(curvedArcDirection);
        this.mDayWv.setCurvedArcDirection(curvedArcDirection);
    }

    public void setCurvedArcDirectionFactor(@FloatRange(from=0.0, to=1.0) float curvedArcDirectionFactor) {
        this.mYearWv.setCurvedArcDirectionFactor(curvedArcDirectionFactor);
        this.mMonthWv.setCurvedArcDirectionFactor(curvedArcDirectionFactor);
        this.mDayWv.setCurvedArcDirectionFactor(curvedArcDirectionFactor);
    }

    @Deprecated
    public void setCurvedRefractRatio(@FloatRange(from=0.0, to=1.0) float curvedRefractRatio) {
        this.setRefractRatio(curvedRefractRatio);
    }

    public void setRefractRatio(@FloatRange(from=0.0, to=1.0) float curvedRefractRatio) {
        this.mYearWv.setRefractRatio(curvedRefractRatio);
        this.mMonthWv.setRefractRatio(curvedRefractRatio);
        this.mDayWv.setRefractRatio(curvedRefractRatio);
    }

    public AppCompatTextView getYearTv() {
        return this.mYearTv;
    }

    public AppCompatTextView getMonthTv() {
        return this.mMonthTv;
    }

    public AppCompatTextView getDayTv() {
        return this.mDayTv;
    }
}

