/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.picker;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zyyoona7.picker.listener.OnOptionsSelectedListener;
import com.zyyoona7.picker.listener.OnPickerScrollStateChangedListener;
import com.zyyoona7.wheel.WheelView;
import java.util.List;

public class OptionsPickerView<T>
extends LinearLayout
implements WheelView.OnItemSelectedListener<T>,
WheelView.OnWheelChangedListener {
    private static final int ID_OPTIONS_WV_1 = 1;
    private static final int ID_OPTIONS_WV_2 = 2;
    private static final int ID_OPTIONS_WV_3 = 3;
    private WheelView<T> mOptionsWv1;
    private WheelView<T> mOptionsWv2;
    private WheelView<T> mOptionsWv3;
    private List<T> mOptionsData1;
    private List<List<T>> mOptionsData2;
    private List<List<List<T>>> mOptionsData3;
    private boolean isLinkage;
    private boolean isResetSelectedPosition;
    private OnOptionsSelectedListener<T> mOnOptionsSelectedListener;
    private OnPickerScrollStateChangedListener mOnPickerScrollStateChangedListener;

    public OptionsPickerView(Context context) {
        this(context, null);
    }

    public OptionsPickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OptionsPickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews(context);
    }

    private void initViews(Context context) {
        this.setOrientation(0);
        this.mOptionsWv1 = new WheelView(context);
        this.mOptionsWv1.setId(1);
        this.mOptionsWv2 = new WheelView(context);
        this.mOptionsWv2.setId(2);
        this.mOptionsWv3 = new WheelView(context);
        this.mOptionsWv3.setId(3);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2);
        layoutParams.weight = 1.0f;
        this.addView((View)this.mOptionsWv1, (ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.mOptionsWv2, (ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.mOptionsWv3, (ViewGroup.LayoutParams)layoutParams);
        this.mOptionsWv1.setOnItemSelectedListener((WheelView.OnItemSelectedListener)this);
        this.mOptionsWv2.setOnItemSelectedListener((WheelView.OnItemSelectedListener)this);
        this.mOptionsWv3.setOnItemSelectedListener((WheelView.OnItemSelectedListener)this);
        this.mOptionsWv1.setAutoFitTextSize(true);
        this.mOptionsWv2.setAutoFitTextSize(true);
        this.mOptionsWv3.setAutoFitTextSize(true);
        this.mOptionsWv1.setOnWheelChangedListener((WheelView.OnWheelChangedListener)this);
        this.mOptionsWv2.setOnWheelChangedListener((WheelView.OnWheelChangedListener)this);
        this.mOptionsWv3.setOnWheelChangedListener((WheelView.OnWheelChangedListener)this);
    }

    public void setData(List<T> data) {
        this.setData(data, null, null);
    }

    public void setData(List<T> data1, List<T> data2) {
        this.setData(data1, data2, null);
    }

    public void setData(List<T> data1, List<T> data2, List<T> data3) {
        this.isLinkage = false;
        this.setDataOrGone(data1, this.mOptionsWv1);
        this.setDataOrGone(data2, this.mOptionsWv2);
        this.setDataOrGone(data3, this.mOptionsWv3);
    }

    private void setDataOrGone(List<T> data, WheelView<T> wheelView) {
        if (data != null) {
            wheelView.setData(data);
        } else {
            wheelView.setVisibility(8);
        }
    }

    public void setLinkageData(List<T> linkageData1, List<List<T>> linkageData2) {
        this.setLinkageData(linkageData1, linkageData2, null);
    }

    public void setLinkageData(List<T> linkageData1, List<List<T>> linkageData2, List<List<List<T>>> linkageData3) {
        if (linkageData1 == null || linkageData1.size() == 0 || linkageData2 == null || linkageData2.size() == 0) {
            return;
        }
        if (linkageData1.size() != linkageData2.size()) {
            throw new IllegalArgumentException("linkageData1 and linkageData3 are not the same size.");
        }
        this.isLinkage = true;
        this.mOptionsData1 = linkageData1;
        this.mOptionsData2 = linkageData2;
        if (linkageData3 == null) {
            this.mOptionsData3 = null;
            this.mOptionsWv3.setVisibility(8);
            this.mOptionsWv1.setData(linkageData1);
            this.mOptionsWv2.setData(linkageData2.get(0));
        } else {
            this.mOptionsWv3.setVisibility(0);
            if (linkageData1.size() != linkageData3.size()) {
                throw new IllegalArgumentException("linkageData1 and linkageData3 are not the same size.");
            }
            for (int i = 0; i < linkageData1.size(); ++i) {
                if (linkageData2.get(i).size() == linkageData3.get(i).size()) continue;
                throw new IllegalArgumentException("linkageData2 index " + i + " List and linkageData3 index " + i + " List are not the same size.");
            }
            this.mOptionsData3 = linkageData3;
            this.mOptionsWv1.setData(linkageData1);
            this.mOptionsWv2.setData(linkageData2.get(0));
            this.mOptionsWv3.setData(linkageData3.get(0).get(0));
            if (this.isResetSelectedPosition) {
                this.mOptionsWv1.setSelectedItemPosition(0);
                this.mOptionsWv2.setSelectedItemPosition(0);
                this.mOptionsWv3.setSelectedItemPosition(0);
            }
        }
    }

    public void onItemSelected(WheelView<T> wheelView, T data, int position) {
        if (this.isLinkage) {
            if (wheelView.getId() == 1) {
                this.mOptionsWv2.setData(this.mOptionsData2.get(position));
                if (this.mOptionsData3 != null) {
                    this.mOptionsWv3.setData(this.mOptionsData3.get(position).get(this.mOptionsWv2.getSelectedItemPosition()));
                }
            } else if (wheelView.getId() == 2 && this.mOptionsData3 != null) {
                this.mOptionsWv3.setData(this.mOptionsData3.get(this.mOptionsWv1.getSelectedItemPosition()).get(position));
            }
            if (this.mOnOptionsSelectedListener != null) {
                int opt1Pos = this.mOptionsWv1.getSelectedItemPosition();
                int opt2Pos = this.mOptionsWv2.getSelectedItemPosition();
                int opt3Pos = this.mOptionsData3 == null ? -1 : this.mOptionsWv3.getSelectedItemPosition();
                T opt1Data = this.mOptionsData1.get(opt1Pos);
                T opt2Data = this.mOptionsData2.get(opt1Pos).get(opt2Pos);
                Object opt3Data = null;
                if (this.mOptionsData3 != null) {
                    opt3Data = this.mOptionsData3.get(opt1Pos).get(opt2Pos).get(opt3Pos);
                }
                this.mOnOptionsSelectedListener.onOptionsSelected(opt1Pos, opt1Data, opt2Pos, opt2Data, opt3Pos, opt3Data);
            }
        } else if (this.mOnOptionsSelectedListener != null) {
            boolean isOpt1Shown = this.mOptionsWv1.getVisibility() == 0;
            int opt1Pos = isOpt1Shown ? this.mOptionsWv1.getSelectedItemPosition() : -1;
            boolean isOpt2Shown = this.mOptionsWv2.getVisibility() == 0;
            int opt2Pos = isOpt2Shown ? this.mOptionsWv2.getSelectedItemPosition() : -1;
            boolean isOpt3Shown = this.mOptionsWv3.getVisibility() == 0;
            int opt3Pos = isOpt3Shown ? this.mOptionsWv3.getSelectedItemPosition() : -1;
            Object opt1Data = isOpt1Shown ? this.mOptionsWv1.getSelectedItemData() : null;
            Object opt2Data = isOpt2Shown ? this.mOptionsWv2.getSelectedItemData() : null;
            Object opt3Data = isOpt3Shown ? this.mOptionsWv3.getSelectedItemData() : null;
            this.mOnOptionsSelectedListener.onOptionsSelected(opt1Pos, opt1Data, opt2Pos, opt2Data, opt3Pos, opt3Data);
        }
    }

    public boolean isResetSelectedPosition() {
        return this.isResetSelectedPosition;
    }

    public void setResetSelectedPosition(boolean isResetSelectedPosition) {
        this.isResetSelectedPosition = isResetSelectedPosition;
        this.mOptionsWv1.setResetSelectedPosition(isResetSelectedPosition);
        this.mOptionsWv2.setResetSelectedPosition(isResetSelectedPosition);
        this.mOptionsWv3.setResetSelectedPosition(isResetSelectedPosition);
    }

    public void setSoundEffect(boolean isSoundEffect) {
        this.mOptionsWv1.setSoundEffect(isSoundEffect);
        this.mOptionsWv2.setSoundEffect(isSoundEffect);
        this.mOptionsWv3.setSoundEffect(isSoundEffect);
    }

    public void setSoundEffectResource(@RawRes int rawResId) {
        this.mOptionsWv1.setSoundEffectResource(rawResId);
        this.mOptionsWv2.setSoundEffectResource(rawResId);
        this.mOptionsWv3.setSoundEffectResource(rawResId);
    }

    public void setPlayVolume(@FloatRange(from=0.0, to=1.0) float playVolume) {
        this.mOptionsWv1.setPlayVolume(playVolume);
        this.mOptionsWv2.setPlayVolume(playVolume);
        this.mOptionsWv3.setPlayVolume(playVolume);
    }

    public void setTextSize(float textSize) {
        this.setTextSize(textSize, false);
    }

    public void setTextSize(float textSize, boolean isSp) {
        this.mOptionsWv1.setTextSize(textSize, isSp);
        this.mOptionsWv2.setTextSize(textSize, isSp);
        this.mOptionsWv3.setTextSize(textSize, isSp);
    }

    public void setAutoFitTextSize(boolean isAutoFitTextSize) {
        this.mOptionsWv1.setAutoFitTextSize(isAutoFitTextSize);
        this.mOptionsWv2.setAutoFitTextSize(isAutoFitTextSize);
        this.mOptionsWv3.setAutoFitTextSize(isAutoFitTextSize);
    }

    public void setTypeface(Typeface typeface) {
        this.mOptionsWv1.setTypeface(typeface);
        this.mOptionsWv2.setTypeface(typeface);
        this.mOptionsWv3.setTypeface(typeface);
    }

    public void setTextAlign(int textAlign) {
        this.mOptionsWv1.setTextAlign(textAlign);
        this.mOptionsWv2.setTextAlign(textAlign);
        this.mOptionsWv3.setTextAlign(textAlign);
    }

    public void setNormalItemTextColorRes(@ColorRes int textColorRes) {
        this.setNormalItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public void setNormalItemTextColor(@ColorInt int textColor) {
        this.mOptionsWv1.setNormalItemTextColor(textColor);
        this.mOptionsWv2.setNormalItemTextColor(textColor);
        this.mOptionsWv3.setNormalItemTextColor(textColor);
    }

    public void setSelectedItemTextColorRes(@ColorRes int selectedItemTextColorRes) {
        this.setSelectedItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedItemTextColorRes));
    }

    public void setSelectedItemTextColor(@ColorInt int selectedItemTextColor) {
        this.mOptionsWv1.setSelectedItemTextColor(selectedItemTextColor);
        this.mOptionsWv2.setSelectedItemTextColor(selectedItemTextColor);
        this.mOptionsWv3.setSelectedItemTextColor(selectedItemTextColor);
    }

    public void setTextBoundaryMargin(float textBoundaryMargin) {
        this.setTextBoundaryMargin(textBoundaryMargin, false);
    }

    public void setTextBoundaryMargin(float textBoundaryMargin, boolean isDp) {
        this.mOptionsWv1.setTextBoundaryMargin(textBoundaryMargin, isDp);
        this.mOptionsWv2.setTextBoundaryMargin(textBoundaryMargin, isDp);
        this.mOptionsWv3.setTextBoundaryMargin(textBoundaryMargin, isDp);
    }

    public void setLineSpacing(float lineSpacing) {
        this.setLineSpacing(lineSpacing, false);
    }

    public void setLineSpacing(float lineSpacing, boolean isDp) {
        this.mOptionsWv1.setLineSpacing(lineSpacing, isDp);
        this.mOptionsWv2.setLineSpacing(lineSpacing, isDp);
        this.mOptionsWv3.setLineSpacing(lineSpacing, isDp);
    }

    public void setVisibleItems(int visibleItems) {
        this.mOptionsWv1.setVisibleItems(visibleItems);
        this.mOptionsWv2.setVisibleItems(visibleItems);
        this.mOptionsWv3.setVisibleItems(visibleItems);
    }

    public void setCyclic(boolean isCyclic) {
        this.mOptionsWv1.setCyclic(isCyclic);
        this.mOptionsWv2.setCyclic(isCyclic);
        this.mOptionsWv3.setCyclic(isCyclic);
    }

    public void setShowDivider(boolean isShowDivider) {
        this.mOptionsWv1.setShowDivider(isShowDivider);
        this.mOptionsWv2.setShowDivider(isShowDivider);
        this.mOptionsWv3.setShowDivider(isShowDivider);
    }

    public void setDividerColorRes(@ColorRes int dividerColorRes) {
        this.setDividerColor(ContextCompat.getColor((Context)this.getContext(), (int)dividerColorRes));
    }

    public void setDividerColor(@ColorInt int dividerColor) {
        this.mOptionsWv1.setDividerColor(dividerColor);
        this.mOptionsWv2.setDividerColor(dividerColor);
        this.mOptionsWv3.setDividerColor(dividerColor);
    }

    public void setDividerHeight(float dividerHeight) {
        this.setDividerHeight(dividerHeight, false);
    }

    public void setDividerHeight(float dividerHeight, boolean isDp) {
        this.mOptionsWv1.setDividerHeight(dividerHeight, isDp);
        this.mOptionsWv2.setDividerHeight(dividerHeight, isDp);
        this.mOptionsWv3.setDividerHeight(dividerHeight, isDp);
    }

    public void setDividerType(int dividerType) {
        this.mOptionsWv1.setDividerType(dividerType);
        this.mOptionsWv2.setDividerType(dividerType);
        this.mOptionsWv3.setDividerType(dividerType);
    }

    public void setDividerPaddingForWrap(float dividerPaddingForWrap) {
        this.setDividerPaddingForWrap(dividerPaddingForWrap, false);
    }

    public void setDividerPaddingForWrap(float dividerPaddingForWrap, boolean isDp) {
        this.mOptionsWv1.setDividerPaddingForWrap(dividerPaddingForWrap, isDp);
        this.mOptionsWv2.setDividerPaddingForWrap(dividerPaddingForWrap, isDp);
        this.mOptionsWv3.setDividerPaddingForWrap(dividerPaddingForWrap, isDp);
    }

    public void setDividerCap(Paint.Cap dividerCap) {
        this.mOptionsWv1.setDividerCap(dividerCap);
        this.mOptionsWv2.setDividerCap(dividerCap);
        this.mOptionsWv3.setDividerCap(dividerCap);
    }

    public void setDrawSelectedRect(boolean isDrawSelectedRect) {
        this.mOptionsWv1.setDrawSelectedRect(isDrawSelectedRect);
        this.mOptionsWv2.setDrawSelectedRect(isDrawSelectedRect);
        this.mOptionsWv3.setDrawSelectedRect(isDrawSelectedRect);
    }

    public void setSelectedRectColorRes(@ColorRes int selectedRectColorRes) {
        this.setSelectedRectColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedRectColorRes));
    }

    public void setSelectedRectColor(@ColorInt int selectedRectColor) {
        this.mOptionsWv1.setSelectedRectColor(selectedRectColor);
        this.mOptionsWv2.setSelectedRectColor(selectedRectColor);
        this.mOptionsWv3.setSelectedRectColor(selectedRectColor);
    }

    public void setCurved(boolean isCurved) {
        this.mOptionsWv1.setCurved(isCurved);
        this.mOptionsWv2.setCurved(isCurved);
        this.mOptionsWv3.setCurved(isCurved);
    }

    public void setCurvedArcDirection(int curvedArcDirection) {
        this.mOptionsWv1.setCurvedArcDirection(curvedArcDirection);
        this.mOptionsWv2.setCurvedArcDirection(curvedArcDirection);
        this.mOptionsWv3.setCurvedArcDirection(curvedArcDirection);
    }

    public void setCurvedArcDirectionFactor(@FloatRange(from=0.0, to=1.0) float curvedArcDirectionFactor) {
        this.mOptionsWv1.setCurvedArcDirectionFactor(curvedArcDirectionFactor);
        this.mOptionsWv2.setCurvedArcDirectionFactor(curvedArcDirectionFactor);
        this.mOptionsWv3.setCurvedArcDirectionFactor(curvedArcDirectionFactor);
    }

    @Deprecated
    public void setCurvedRefractRatio(@FloatRange(from=0.0, to=1.0) float curvedRefractRatio) {
        this.setRefractRatio(curvedRefractRatio);
    }

    public void setRefractRatio(@FloatRange(from=0.0, to=1.0) float curvedRefractRatio) {
        this.mOptionsWv1.setRefractRatio(curvedRefractRatio);
        this.mOptionsWv2.setRefractRatio(curvedRefractRatio);
        this.mOptionsWv3.setRefractRatio(curvedRefractRatio);
    }

    public OnOptionsSelectedListener<T> getOnOptionsSelectedListener() {
        return this.mOnOptionsSelectedListener;
    }

    public void setOnOptionsSelectedListener(OnOptionsSelectedListener<T> onOptionsSelectedListener) {
        this.mOnOptionsSelectedListener = onOptionsSelectedListener;
    }

    public void setOnPickerScrollStateChangedListener(OnPickerScrollStateChangedListener listener) {
        this.mOnPickerScrollStateChangedListener = listener;
    }

    public int getOpt1SelectedPosition() {
        return this.mOptionsWv1.getSelectedItemPosition();
    }

    public void setOpt1SelectedPosition(int position) {
        this.setOpt1SelectedPosition(position, false);
    }

    public void setOpt1SelectedPosition(int position, boolean isSmoothScroll) {
        this.setOpt1SelectedPosition(position, isSmoothScroll, 0);
    }

    public void setOpt1SelectedPosition(int position, boolean isSmoothScroll, int smoothDuration) {
        this.mOptionsWv1.setSelectedItemPosition(position, isSmoothScroll, smoothDuration);
    }

    public int getOpt2SelectedPosition() {
        return this.mOptionsWv2.getSelectedItemPosition();
    }

    public void setOpt2SelectedPosition(int position) {
        this.setOpt2SelectedPosition(position, false);
    }

    public void setOpt2SelectedPosition(int position, boolean isSmoothScroll) {
        this.setOpt2SelectedPosition(position, isSmoothScroll, 0);
    }

    public void setOpt2SelectedPosition(int position, boolean isSmoothScroll, int smoothDuration) {
        this.mOptionsWv2.setSelectedItemPosition(position, isSmoothScroll, smoothDuration);
    }

    public int getOpt3SelectedPosition() {
        return this.mOptionsWv3.getSelectedItemPosition();
    }

    public void setOpt3SelectedPosition(int position) {
        this.setOpt3SelectedPosition(position, false);
    }

    public void setOpt3SelectedPosition(int position, boolean isSmoothScroll) {
        this.setOpt3SelectedPosition(position, isSmoothScroll, 0);
    }

    public void setOpt3SelectedPosition(int position, boolean isSmoothScroll, int smoothDuration) {
        this.mOptionsWv3.setSelectedItemPosition(position, isSmoothScroll, smoothDuration);
    }

    public T getOpt1SelectedData() {
        if (this.isLinkage) {
            return this.mOptionsData1.get(this.mOptionsWv1.getSelectedItemPosition());
        }
        return (T)this.mOptionsWv1.getSelectedItemData();
    }

    public T getOpt2SelectedData() {
        if (this.isLinkage) {
            return this.mOptionsData2.get(this.mOptionsWv1.getSelectedItemPosition()).get(this.mOptionsWv2.getSelectedItemPosition());
        }
        return (T)this.mOptionsWv2.getSelectedItemData();
    }

    public T getOpt3SelectedData() {
        if (this.isLinkage) {
            return this.mOptionsData3 == null ? null : (T)this.mOptionsData3.get(this.mOptionsWv1.getSelectedItemPosition()).get(this.mOptionsWv2.getSelectedItemPosition()).get(this.mOptionsWv3.getSelectedItemPosition());
        }
        return (T)this.mOptionsWv3.getSelectedItemData();
    }

    public WheelView<T> getOptionsWv1() {
        return this.mOptionsWv1;
    }

    public WheelView<T> getOptionsWv2() {
        return this.mOptionsWv2;
    }

    public WheelView<T> getOptionsWv3() {
        return this.mOptionsWv3;
    }

    public void onWheelScroll(int scrollOffsetY) {
    }

    public void onWheelItemChanged(int oldPosition, int newPosition) {
    }

    public void onWheelSelected(int position) {
    }

    public void onWheelScrollStateChanged(int state) {
        if (this.mOnPickerScrollStateChangedListener != null) {
            this.mOnPickerScrollStateChangedListener.onScrollStateChanged(state);
        }
    }
}

