/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.picker.base;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zyyoona7.picker.ex.DayWheelView;
import com.zyyoona7.picker.ex.MonthWheelView;
import com.zyyoona7.picker.ex.YearWheelView;
import com.zyyoona7.picker.listener.OnDateSelectedListener;
import com.zyyoona7.picker.listener.OnPickerScrollStateChangedListener;
import com.zyyoona7.wheel.WheelView;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public abstract class BaseDatePickerView
extends FrameLayout
implements WheelView.OnItemSelectedListener<Integer>,
WheelView.OnWheelChangedListener {
    private final SimpleDateFormat mYmdSdf = new SimpleDateFormat("yyyy-M-d", Locale.getDefault());
    private final SimpleDateFormat mYmSdf = new SimpleDateFormat("yyyy-M", Locale.getDefault());
    protected YearWheelView mYearWv;
    protected MonthWheelView mMonthWv;
    protected DayWheelView mDayWv;
    private OnDateSelectedListener mOnDateSelectedListener;
    private OnPickerScrollStateChangedListener mOnPickerScrollStateChangedListener;

    public BaseDatePickerView(@NonNull Context context) {
        this(context, null);
    }

    public BaseDatePickerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseDatePickerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.getDatePickerViewLayoutId() != 0) {
            LayoutInflater.from((Context)context).inflate(this.getDatePickerViewLayoutId(), (ViewGroup)this);
        }
    }

    protected void onFinishInflate() {
        int dayId;
        int monthId;
        super.onFinishInflate();
        int yearId = this.getYearWheelViewId();
        if (this.hasViewId(yearId)) {
            this.mYearWv = (YearWheelView)this.findViewById(yearId);
        }
        if (this.hasViewId(monthId = this.getMonthWheelViewId())) {
            this.mMonthWv = (MonthWheelView)this.findViewById(monthId);
        }
        if (this.hasViewId(dayId = this.getDayWheelViewId())) {
            this.mDayWv = (DayWheelView)this.findViewById(dayId);
        }
        if (this.mYearWv != null) {
            this.mYearWv.setOnItemSelectedListener(this);
            this.mYearWv.setOnWheelChangedListener(this);
        }
        if (this.mMonthWv != null) {
            this.mMonthWv.setOnItemSelectedListener(this);
            this.mMonthWv.setOnWheelChangedListener(this);
            if (this.mYearWv != null) {
                this.mMonthWv.setCurrentSelectedYear(this.mYearWv.getSelectedYear());
            }
        }
        if (this.mDayWv != null) {
            this.mDayWv.setOnItemSelectedListener(this);
            this.mDayWv.setOnWheelChangedListener(this);
            if (this.mYearWv != null && this.mMonthWv != null) {
                this.mDayWv.setYearAndMonth(this.mYearWv.getSelectedYear(), this.mMonthWv.getSelectedMonth());
            }
        }
    }

    @LayoutRes
    protected abstract int getDatePickerViewLayoutId();

    @IdRes
    protected abstract int getYearWheelViewId();

    @IdRes
    protected abstract int getMonthWheelViewId();

    @IdRes
    protected abstract int getDayWheelViewId();

    public void onItemSelected(WheelView<Integer> wheelView, Integer data, int position) {
        if (wheelView.getId() == this.getYearWheelViewId()) {
            if (this.mDayWv != null) {
                this.mDayWv.setYear(data);
            }
            if (this.mMonthWv != null) {
                this.mMonthWv.setCurrentSelectedYear(data);
            }
        } else if (wheelView.getId() == this.getMonthWheelViewId() && this.mDayWv != null) {
            this.mDayWv.setMonth(data);
        }
        int year = this.mYearWv == null ? 1970 : this.mYearWv.getSelectedYear();
        int month = this.mMonthWv == null ? 1 : this.mMonthWv.getSelectedMonth();
        int day = this.mDayWv == null ? 1 : this.mDayWv.getSelectedDay();
        String date = year + "-" + month + "-" + day;
        if (this.mOnDateSelectedListener != null) {
            try {
                Date formatDate = null;
                if (this.isAllShown()) {
                    formatDate = this.mYmdSdf.parse(date);
                } else if (this.isYmShown()) {
                    formatDate = this.mYmSdf.parse(date);
                }
                this.mOnDateSelectedListener.onDateSelected(this, year, month, day, formatDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void onWheelScroll(int scrollOffsetY) {
    }

    public void onWheelItemChanged(int oldPosition, int newPosition) {
    }

    public void onWheelSelected(int position) {
    }

    public void onWheelScrollStateChanged(int state) {
        if (this.mOnPickerScrollStateChangedListener != null) {
            this.mOnPickerScrollStateChangedListener.onScrollStateChanged(state);
        }
    }

    private boolean isAllShown() {
        return this.isYmShown() && this.mDayWv != null && this.mDayWv.getVisibility() == 0;
    }

    private boolean isYmShown() {
        return this.mYearWv != null && this.mYearWv.getVisibility() == 0 && this.mMonthWv != null && this.mMonthWv.getVisibility() == 0;
    }

    private boolean hasViewId(@IdRes int idRes) {
        return idRes != 0 && idRes != -1;
    }

    public YearWheelView getYearWv() {
        return this.mYearWv;
    }

    public MonthWheelView getMonthWv() {
        return this.mMonthWv;
    }

    public DayWheelView getDayWv() {
        return this.mDayWv;
    }

    public void setOnDateSelectedListener(OnDateSelectedListener onDateSelectedListener) {
        this.mOnDateSelectedListener = onDateSelectedListener;
    }

    public void setOnPickerScrollStateChangedListener(OnPickerScrollStateChangedListener listener) {
        this.mOnPickerScrollStateChangedListener = listener;
    }

    public void setMaxDate(@NonNull Calendar calendar) {
        this.setMaxDate(calendar.getTime());
    }

    public void setMaxDate(@NonNull Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int maxYear = calendar.get(1);
        int maxMonth = calendar.get(2) + 1;
        int maxDay = calendar.get(5);
        if (this.mYearWv != null) {
            this.mYearWv.setMaxYear(maxYear);
        }
        if (this.mMonthWv != null) {
            this.mMonthWv.setMaxYearAndMonth(maxYear, maxMonth);
        }
        if (this.mDayWv != null) {
            this.mDayWv.setMaxYearMonthAndDay(maxYear, maxMonth, maxDay);
        }
    }

    public void setMinDate(@NonNull Calendar calendar) {
        this.setMinDate(calendar.getTime());
    }

    public void setMinDate(@NonNull Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int minYear = calendar.get(1);
        int minMonth = calendar.get(2) + 1;
        int minDay = calendar.get(5);
        if (this.mYearWv != null) {
            this.mYearWv.setMinYear(minYear);
        }
        if (this.mMonthWv != null) {
            this.mMonthWv.setMinYearAndMonth(minYear, minMonth);
        }
        if (this.mDayWv != null) {
            this.mDayWv.setMinYearMonthAndDay(minYear, minMonth, minDay);
        }
    }
}

