/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.picker.ex;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.SparseArray;
import com.zyyoona7.picker.R;
import com.zyyoona7.wheel.WheelView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DayWheelView
extends WheelView<Integer> {
    private static final SparseArray<List<Integer>> DAYS = new SparseArray(1);
    private int mYear;
    private int mMonth;
    private int mMaxYear = -1;
    private int mMinYear = -1;
    private int mMaxMonth = -1;
    private int mMinMonth = -1;
    private int mMaxDay = -1;
    private int mMinDay = -1;
    private Calendar mCalendar = Calendar.getInstance();

    public DayWheelView(Context context) {
        this(context, null);
    }

    public DayWheelView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DayWheelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.DayWheelView);
        this.mYear = typedArray.getInt(R.styleable.DayWheelView_wv_year, this.mCalendar.get(1));
        this.mMonth = typedArray.getInt(R.styleable.DayWheelView_wv_month, this.mCalendar.get(2) + 1);
        int selectedDay = typedArray.getInt(R.styleable.DayWheelView_wv_selectedDay, this.mCalendar.get(5));
        typedArray.recycle();
        this.updateDay();
        this.setSelectedDay(selectedDay);
    }

    public void setYearAndMonth(int year, int month) {
        this.mYear = year;
        this.mMonth = month;
        this.updateDay();
    }

    public void setYear(int year) {
        this.mYear = year;
        this.updateDay();
    }

    public int getYear() {
        return this.mYear;
    }

    public void setMonth(int month) {
        this.mMonth = month;
        this.updateDay();
    }

    public int getMonth() {
        return this.mMonth;
    }

    public void setMaxYearMonthAndDay(@IntRange(from=0L) int maxYear, @IntRange(from=1L, to=12L) int maxMonth, @IntRange(from=1L, to=31L) int maxDay) {
        this.mMaxYear = maxYear;
        this.mMaxMonth = maxMonth;
        this.mMaxDay = maxDay;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public void setMinYearMonthAndDay(@IntRange(from=0L) int minYear, @IntRange(from=1L, to=12L) int minMonth, @IntRange(from=1L, to=31L) int minDay) {
        this.mMinYear = minYear;
        this.mMinMonth = minMonth;
        this.mMinDay = minDay;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    private void updateDay() {
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(2, this.mMonth - 1);
        this.mCalendar.set(5, 1);
        this.mCalendar.roll(5, -1);
        int days = this.mCalendar.get(5);
        ArrayList<Integer> data = (ArrayList<Integer>)DAYS.get(days);
        if (data == null) {
            data = new ArrayList<Integer>(1);
            for (int i = 1; i <= days; ++i) {
                data.add(i);
            }
            DAYS.put(days, data);
        }
        super.setData((List)data);
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public int getSelectedDay() {
        return (Integer)this.getSelectedItemData();
    }

    public void setSelectedDay(int selectedDay) {
        this.setSelectedDay(selectedDay, false);
    }

    public void setSelectedDay(int selectedDay, boolean isSmoothScroll) {
        this.setSelectedDay(selectedDay, isSmoothScroll, 0);
    }

    public void setSelectedDay(int selectedDay, boolean isSmoothScroll, int smoothDuration) {
        int days = this.mCalendar.get(5);
        if (selectedDay >= 1 && selectedDay <= days) {
            int shouldSelected = selectedDay;
            if (this.isMoreThanMaxDay(selectedDay)) {
                shouldSelected = this.mMaxDay;
            } else if (this.isLessThanMinDay(selectedDay)) {
                shouldSelected = this.mMinDay;
            }
            this.updateSelectedDay(shouldSelected, isSmoothScroll, smoothDuration);
        }
    }

    private void updateSelectedDay(int selectedDay, boolean isSmoothScroll, int smoothDuration) {
        this.setSelectedItemPosition(selectedDay - 1, isSmoothScroll, smoothDuration);
    }

    public void setData(List<Integer> dataList) {
        throw new UnsupportedOperationException("You can not invoke setData method in " + DayWheelView.class.getSimpleName() + ".");
    }

    protected void onItemSelected(Integer data, int position) {
        this.checkCurrentSelected(data);
    }

    private void checkCurrentSelected(int data) {
        if (this.isMoreThanMaxDay(data)) {
            this.setSelectedDay(this.mMaxDay);
        } else if (this.isLessThanMinDay(data)) {
            this.setSelectedDay(this.mMinDay);
        }
    }

    private boolean isMoreThanMaxDay(int data) {
        return this.isCurrentMaxYear() && this.isCurrentMaxMonth() && data > this.mMaxDay && this.mMaxDay > 0;
    }

    private boolean isLessThanMinDay(int data) {
        return this.isCurrentMinYear() && this.isCurrentMinMonth() && data < this.mMinDay && this.mMinDay > 0;
    }

    private boolean isCurrentMaxYear() {
        return this.mMaxYear > 0 && this.mYear == this.mMaxYear || this.mYear < 0 && this.mMaxYear < 0 && this.mMinYear < 0;
    }

    private boolean isCurrentMinYear() {
        return this.mYear == this.mMinYear && this.mMinYear > 0 || this.mYear < 0 && this.mMaxYear < 0 && this.mMinYear < 0;
    }

    private boolean isCurrentMaxMonth() {
        return this.mMaxMonth > 0 && this.mMonth == this.mMaxMonth || this.mMonth < 0 && this.mMaxMonth < 0 && this.mMinMonth < 0;
    }

    private boolean isCurrentMinMonth() {
        return this.mMonth == this.mMinMonth && this.mMinMonth > 0 || this.mMonth < 0 && this.mMaxMonth < 0 && this.mMinMonth < 0;
    }
}

