/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.picker.ex;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.zyyoona7.picker.R;
import com.zyyoona7.wheel.WheelView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class MonthWheelView
extends WheelView<Integer> {
    private int mCurrentSelectedYear = -1;
    private int mMaxYear = -1;
    private int mMinYear = -1;
    private int mMaxMonth = -1;
    private int mMinMonth = -1;

    public MonthWheelView(Context context) {
        this(context, null);
    }

    public MonthWheelView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MonthWheelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MonthWheelView);
        int selectedMonth = typedArray.getInt(R.styleable.MonthWheelView_wv_selectedMonth, Calendar.getInstance().get(2) + 1);
        typedArray.recycle();
        this.initData();
        this.setSelectedMonth(selectedMonth);
    }

    private void initData() {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        for (int i = 1; i <= 12; ++i) {
            list.add(i);
        }
        super.setData(list);
    }

    public int getCurrentSelectedYear() {
        return this.mCurrentSelectedYear;
    }

    public void setCurrentSelectedYear(@IntRange(from=0L) int currentSelectedYear) {
        this.mCurrentSelectedYear = currentSelectedYear;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public void setMaxYearAndMonth(@IntRange(from=0L) int maxYear, @IntRange(from=1L, to=12L) int maxMonth) {
        this.mMaxYear = maxYear;
        this.mMaxMonth = maxMonth;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public void setMaxMonth(@IntRange(from=1L, to=12L) int maxMonth) {
        this.mMaxMonth = maxMonth;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public void setMinYearAndMonth(@IntRange(from=0L) int minYear, @IntRange(from=1L, to=12L) int minMonth) {
        this.mMinYear = minYear;
        this.mMinMonth = minMonth;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public void setMinMonth(@IntRange(from=1L, to=12L) int minMonth) {
        this.mMinMonth = minMonth;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public int getSelectedMonth() {
        return (Integer)this.getSelectedItemData();
    }

    public void setSelectedMonth(int selectedMonth) {
        this.setSelectedMonth(selectedMonth, false);
    }

    public void setSelectedMonth(int selectedMonth, boolean isSmoothScroll) {
        this.setSelectedMonth(selectedMonth, isSmoothScroll, 0);
    }

    public void setSelectedMonth(int selectedMonth, boolean isSmoothScroll, int smoothDuration) {
        if (selectedMonth >= 1 && selectedMonth <= 12) {
            int shouldSelected = selectedMonth;
            if (this.isMoreThanMaxMonth(selectedMonth)) {
                shouldSelected = this.mMaxMonth;
            } else if (this.isLessThanMinMonth(selectedMonth)) {
                shouldSelected = this.mMinMonth;
            }
            this.updateSelectedMonth(shouldSelected, isSmoothScroll, smoothDuration);
        }
    }

    private void updateSelectedMonth(int selectedMonth, boolean isSmoothScroll, int smoothDuration) {
        this.setSelectedItemPosition(selectedMonth - 1, isSmoothScroll, smoothDuration);
    }

    public void setData(List<Integer> dataList) {
        throw new UnsupportedOperationException("You can not invoke setData method in " + MonthWheelView.class.getSimpleName() + ".");
    }

    protected void onItemSelected(Integer data, int position) {
        this.checkCurrentSelected(data);
    }

    private void checkCurrentSelected(int data) {
        if (this.isMoreThanMaxMonth(data)) {
            this.setSelectedMonth(this.mMaxMonth);
        } else if (this.isLessThanMinMonth(data)) {
            this.setSelectedMonth(this.mMinMonth);
        }
    }

    private boolean isMoreThanMaxMonth(int data) {
        return this.isCurrentMaxYear() && data > this.mMaxMonth && this.mMaxMonth > 0;
    }

    private boolean isLessThanMinMonth(int data) {
        return this.isCurrentMinYear() && data < this.mMinMonth && this.mMinMonth > 0;
    }

    private boolean isCurrentMaxYear() {
        return this.mMaxYear > 0 && this.mCurrentSelectedYear == this.mMaxYear || this.mCurrentSelectedYear < 0 && this.mMaxYear < 0 && this.mMinYear < 0;
    }

    private boolean isCurrentMinYear() {
        return this.mCurrentSelectedYear == this.mMinYear && this.mMinYear > 0 || this.mCurrentSelectedYear < 0 && this.mMaxYear < 0 && this.mMinYear < 0;
    }
}

