/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.picker.ex;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.zyyoona7.picker.R;
import com.zyyoona7.wheel.WheelView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class YearWheelView
extends WheelView<Integer> {
    private int mStartYear;
    private int mEndYear;
    private int mMaxYear = -1;
    private int mMinYear = -1;

    public YearWheelView(Context context) {
        this(context, null);
    }

    public YearWheelView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YearWheelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.YearWheelView);
        this.mStartYear = typedArray.getInt(R.styleable.YearWheelView_wv_startYear, 1900);
        this.mEndYear = typedArray.getInt(R.styleable.YearWheelView_wv_endYear, 2100);
        int selectedYear = typedArray.getInt(R.styleable.YearWheelView_wv_selectedYear, Calendar.getInstance().get(1));
        typedArray.recycle();
        this.updateYear();
        this.setSelectedYear(selectedYear);
    }

    public void setYearRange(int start, int end) {
        this.mStartYear = start;
        this.mEndYear = end;
        this.updateYear();
        this.updateMaxAndMinYear();
    }

    public void setMaxYear(@IntRange(from=0L) int maxYear) {
        if (maxYear > this.mEndYear) {
            this.mMaxYear = this.mEndYear;
            return;
        }
        this.mMaxYear = maxYear;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    public void setMinYear(@IntRange(from=0L) int minYear) {
        if (minYear < this.mStartYear) {
            this.mMinYear = this.mStartYear;
            return;
        }
        this.mMinYear = minYear;
        this.checkCurrentSelected((Integer)this.getSelectedItemData());
    }

    private void updateMaxAndMinYear() {
        if (this.mMaxYear > this.mEndYear) {
            this.mMaxYear = this.mEndYear;
        }
        if (this.mMinYear < this.mStartYear) {
            this.mMinYear = this.mStartYear;
        }
        if (this.mMaxYear < this.mMinYear) {
            this.mMaxYear = this.mMinYear;
        }
    }

    private void updateYear() {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        for (int i = this.mStartYear; i <= this.mEndYear; ++i) {
            list.add(i);
        }
        super.setData(list);
    }

    public int getSelectedYear() {
        return (Integer)this.getSelectedItemData();
    }

    public void setSelectedYear(int selectedYear) {
        this.setSelectedYear(selectedYear, false);
    }

    public void setSelectedYear(int selectedYear, boolean isSmoothScroll) {
        this.setSelectedYear(selectedYear, isSmoothScroll, 0);
    }

    public void setSelectedYear(int selectedYear, boolean isSmoothScroll, int smoothDuration) {
        if (selectedYear >= this.mStartYear && selectedYear <= this.mEndYear) {
            int shouldSelected = selectedYear;
            if (this.isMoreThanMaxYear(selectedYear)) {
                shouldSelected = this.mMaxYear;
            } else if (this.isLessThanMinYear(selectedYear)) {
                shouldSelected = this.mMinYear;
            }
            this.updateSelectedYear(shouldSelected, isSmoothScroll, smoothDuration);
        }
    }

    private void updateSelectedYear(int selectedYear, boolean isSmoothScroll, int smoothDuration) {
        this.setSelectedItemPosition(selectedYear - this.mStartYear, isSmoothScroll, smoothDuration);
    }

    public void setData(List<Integer> dataList) {
        throw new UnsupportedOperationException("You can not invoke setData method in " + YearWheelView.class.getSimpleName() + ".");
    }

    protected void onItemSelected(Integer data, int position) {
        this.checkCurrentSelected(data);
    }

    private void checkCurrentSelected(int data) {
        if (this.isMoreThanMaxYear(data)) {
            this.setSelectedYear(this.mMaxYear);
        } else if (this.isLessThanMinYear(data)) {
            this.setSelectedYear(this.mMinYear);
        }
    }

    private boolean isMoreThanMaxYear(int data) {
        return data > this.mMaxYear && this.mMaxYear > 0;
    }

    private boolean isLessThanMinYear(int data) {
        return data < this.mMinYear && this.mMinYear > 0;
    }
}

