/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui.spherical;

import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.GlUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class CanvasRenderer {
    private static final float WIDTH_UNIT = 0.8f;
    private static final float DISTANCE_UNIT = 1.0f;
    private static final float X_UNIT = -0.4f;
    private static final float Y_UNIT = -0.3f;
    private static final String[] VERTEX_SHADER_CODE = new String[]{"uniform mat4 uMvpMatrix;", "attribute vec3 aPosition;", "attribute vec2 aTexCoords;", "varying vec2 vTexCoords;", "void main() {", "  gl_Position = uMvpMatrix * vec4(aPosition, 1);", "  vTexCoords = aTexCoords;", "}"};
    private static final String[] FRAGMENT_SHADER_CODE = new String[]{"#extension GL_OES_EGL_image_external : require", "precision mediump float;", "uniform samplerExternalOES uTexture;", "varying vec2 vTexCoords;", "void main() {", "  gl_FragColor = texture2D(uTexture, vTexCoords);", "}"};
    private static final int POSITION_COORDS_PER_VERTEX = 3;
    private static final int TEXTURE_COORDS_PER_VERTEX = 2;
    private static final int COORDS_PER_VERTEX = 5;
    private static final int VERTEX_STRIDE_BYTES = 20;
    private static final int VERTEX_COUNT = 4;
    private static final float HALF_PI = 1.5707964f;
    private final FloatBuffer vertexBuffer = GlUtil.createBuffer((int)20);
    private final AtomicBoolean surfaceDirty = new AtomicBoolean();
    private int width;
    private int height;
    private float heightUnit;
    private int program = 0;
    private int mvpMatrixHandle;
    private int positionHandle;
    private int textureCoordsHandle;
    private int textureHandle;
    private int textureId;
    private @MonotonicNonNull SurfaceTexture displaySurfaceTexture;
    private @MonotonicNonNull Surface displaySurface;

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.heightUnit = 0.8f * (float)height / (float)width;
        float[] vertexData = new float[20];
        int vertexDataIndex = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                vertexData[vertexDataIndex++] = -0.4f + 0.8f * (float)x;
                vertexData[vertexDataIndex++] = -0.3f + this.heightUnit * (float)y;
                vertexData[vertexDataIndex++] = -1.0f;
                vertexData[vertexDataIndex++] = x;
                vertexData[vertexDataIndex++] = 1 - y;
            }
        }
        this.vertexBuffer.position(0);
        this.vertexBuffer.put(vertexData);
    }

    @Nullable
    public Canvas lockCanvas() {
        return this.displaySurface == null ? null : this.displaySurface.lockCanvas(null);
    }

    public void unlockCanvasAndPost(@Nullable Canvas canvas) {
        if (canvas == null || this.displaySurface == null) {
            return;
        }
        this.displaySurface.unlockCanvasAndPost(canvas);
    }

    public void init() {
        if (this.program != 0) {
            return;
        }
        this.program = GlUtil.compileProgram((String[])VERTEX_SHADER_CODE, (String[])FRAGMENT_SHADER_CODE);
        this.mvpMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMvpMatrix");
        this.positionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.textureCoordsHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTexCoords");
        this.textureHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uTexture");
        this.textureId = GlUtil.createExternalTexture();
        GlUtil.checkGlError();
        this.displaySurfaceTexture = new SurfaceTexture(this.textureId);
        this.displaySurfaceTexture.setOnFrameAvailableListener(surfaceTexture -> this.surfaceDirty.set(true));
        this.displaySurfaceTexture.setDefaultBufferSize(this.width, this.height);
        this.displaySurface = new Surface(this.displaySurfaceTexture);
    }

    public void draw(float[] viewProjectionMatrix) {
        if (this.displaySurfaceTexture == null) {
            return;
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkGlError();
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.textureCoordsHandle);
        GlUtil.checkGlError();
        GLES20.glUniformMatrix4fv((int)this.mvpMatrixHandle, (int)1, (boolean)false, (float[])viewProjectionMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.textureId);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GlUtil.checkGlError();
        this.vertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.vertexBuffer);
        GlUtil.checkGlError();
        this.vertexBuffer.position(3);
        GLES20.glVertexAttribPointer((int)this.textureCoordsHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.vertexBuffer);
        GlUtil.checkGlError();
        if (this.surfaceDirty.compareAndSet(true, false)) {
            this.displaySurfaceTexture.updateTexImage();
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError();
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.textureCoordsHandle);
    }

    public void shutdown() {
        if (this.program != 0) {
            GLES20.glDeleteProgram((int)this.program);
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        }
        if (this.displaySurfaceTexture != null) {
            this.displaySurfaceTexture.release();
        }
        if (this.displaySurface != null) {
            this.displaySurface.release();
        }
    }

    @Nullable
    public PointF translateClick(float yaw, float pitch) {
        return CanvasRenderer.internalTranslateClick(yaw, pitch, -0.4f, -0.3f, 0.8f, this.heightUnit, this.width, this.height);
    }

    @Nullable
    static PointF internalTranslateClick(float yaw, float pitch, float xUnit, float yUnit, float widthUnit, float heightUnit, int widthPixel, int heightPixel) {
        if (yaw >= 1.5707964f || yaw <= -1.5707964f || pitch >= 1.5707964f || pitch <= -1.5707964f) {
            return null;
        }
        double clickXUnit = Math.tan(yaw) * 1.0 - (double)xUnit;
        double clickYUnit = Math.tan(pitch) * 1.0 - (double)yUnit;
        if (clickXUnit < 0.0 || clickXUnit > (double)widthUnit || clickYUnit < 0.0 || clickYUnit > (double)heightUnit) {
            return null;
        }
        float clickXPixel = (float)((double)widthPixel - clickXUnit * (double)widthPixel / (double)widthUnit);
        float clickYPixel = (float)((double)heightPixel - clickYUnit * (double)heightPixel / (double)heightUnit);
        return new PointF(clickXPixel, clickYPixel);
    }
}

