/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui.spherical;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.google.android.exoplayer2.util.GlUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public final class PointerRenderer {
    private static final float SIZE = 0.01f;
    private static final float DISTANCE = 1.0f;
    private static final String[] VERTEX_SHADER_CODE = new String[]{"uniform mat4 uMvpMatrix;", "attribute vec3 aPosition;", "varying vec2 vCoords;", "void main() {", "  gl_Position = uMvpMatrix * vec4(aPosition, 1);", "  vCoords = aPosition.xy / vec2(0.01, 0.01);", "}"};
    private static final String[] FRAGMENT_SHADER_CODE = new String[]{"precision mediump float;", "varying vec2 vCoords;", "void main() {", "  float r = length(vCoords);", "  float alpha = smoothstep(0.5, 0.6, r) * (1.0 - smoothstep(0.8, 0.9, r));", "  if (alpha == 0.0) {", "    discard;", "  } else {", "    gl_FragColor = vec4(alpha);", "  }", "}"};
    private static final int COORDS_PER_VERTEX = 3;
    private static final float[] VERTEX_DATA = new float[]{-0.01f, -0.01f, -1.0f, 0.01f, -0.01f, -1.0f, -0.01f, 0.01f, -1.0f, 0.01f, 0.01f, -1.0f};
    private final FloatBuffer vertexBuffer = GlUtil.createBuffer((float[])VERTEX_DATA);
    private final float[] modelViewProjectionMatrix = new float[16];
    private final float[] controllerOrientationMatrix = new float[16];
    private int program = 0;
    private int mvpMatrixHandle;
    private int positionHandle;

    public PointerRenderer() {
        Matrix.setIdentityM((float[])this.controllerOrientationMatrix, (int)0);
    }

    public void init() {
        if (this.program != 0) {
            return;
        }
        this.program = GlUtil.compileProgram((String[])VERTEX_SHADER_CODE, (String[])FRAGMENT_SHADER_CODE);
        this.mvpMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMvpMatrix");
        this.positionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        GlUtil.checkGlError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(float[] viewProjectionMatrix) {
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkGlError();
        float[] fArray = this.controllerOrientationMatrix;
        synchronized (this.controllerOrientationMatrix) {
            Matrix.multiplyMM((float[])this.modelViewProjectionMatrix, (int)0, (float[])viewProjectionMatrix, (int)0, (float[])this.controllerOrientationMatrix, (int)0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            GLES20.glUniformMatrix4fv((int)this.mvpMatrixHandle, (int)1, (boolean)false, (float[])this.modelViewProjectionMatrix, (int)0);
            GlUtil.checkGlError();
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            GlUtil.checkGlError();
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)this.vertexBuffer);
            GlUtil.checkGlError();
            GLES20.glDrawArrays((int)5, (int)0, (int)(VERTEX_DATA.length / 3));
            GlUtil.checkGlError();
            GLES20.glDisableVertexAttribArray((int)this.positionHandle);
            return;
        }
    }

    public void shutdown() {
        if (this.program != 0) {
            GLES20.glDeleteProgram((int)this.program);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControllerOrientation(float[] rotationMatrix) {
        float[] fArray = this.controllerOrientationMatrix;
        synchronized (this.controllerOrientationMatrix) {
            System.arraycopy(rotationMatrix, 0, this.controllerOrientationMatrix, 0, rotationMatrix.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

