/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui.spherical;

import android.opengl.GLES20;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.android.exoplayer2.video.spherical.Projection;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ProjectionRenderer {
    private static final String[] VERTEX_SHADER_CODE = new String[]{"uniform mat4 uMvpMatrix;", "uniform mat3 uTexMatrix;", "attribute vec4 aPosition;", "attribute vec2 aTexCoords;", "varying vec2 vTexCoords;", "void main() {", "  gl_Position = uMvpMatrix * aPosition;", "  vTexCoords = (uTexMatrix * vec3(aTexCoords, 1)).xy;", "}"};
    private static final String[] FRAGMENT_SHADER_CODE = new String[]{"#extension GL_OES_EGL_image_external : require", "precision mediump float;", "uniform samplerExternalOES uTexture;", "varying vec2 vTexCoords;", "void main() {", "  gl_FragColor = texture2D(uTexture, vTexCoords);", "}"};
    private static final float[] TEX_MATRIX_WHOLE = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] TEX_MATRIX_TOP = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -0.5f, 0.0f, 0.0f, 0.5f, 1.0f};
    private static final float[] TEX_MATRIX_BOTTOM = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] TEX_MATRIX_LEFT = new float[]{0.5f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] TEX_MATRIX_RIGHT = new float[]{0.5f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.5f, 1.0f, 1.0f};
    private int stereoMode;
    private @Nullable MeshData leftMeshData;
    private @Nullable MeshData rightMeshData;
    private int program;
    private int mvpMatrixHandle;
    private int uTexMatrixHandle;
    private int positionHandle;
    private int texCoordsHandle;
    private int textureHandle;

    ProjectionRenderer() {
    }

    public static boolean isSupported(Projection projection) {
        Projection.Mesh leftMesh = projection.leftMesh;
        Projection.Mesh rightMesh = projection.rightMesh;
        return leftMesh.getSubMeshCount() == 1 && leftMesh.getSubMesh((int)0).textureId == 0 && rightMesh.getSubMeshCount() == 1 && rightMesh.getSubMesh((int)0).textureId == 0;
    }

    public void setProjection(Projection projection) {
        if (!ProjectionRenderer.isSupported(projection)) {
            return;
        }
        this.stereoMode = projection.stereoMode;
        this.leftMeshData = new MeshData(projection.leftMesh.getSubMesh(0));
        this.rightMeshData = projection.singleMesh ? this.leftMeshData : new MeshData(projection.rightMesh.getSubMesh(0));
    }

    void init() {
        this.program = GlUtil.compileProgram((String[])VERTEX_SHADER_CODE, (String[])FRAGMENT_SHADER_CODE);
        this.mvpMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMvpMatrix");
        this.uTexMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uTexMatrix");
        this.positionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.texCoordsHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTexCoords");
        this.textureHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uTexture");
    }

    void draw(int textureId, float[] mvpMatrix, boolean rightEye) {
        MeshData meshData;
        MeshData meshData2 = meshData = rightEye ? this.rightMeshData : this.leftMeshData;
        if (meshData == null) {
            return;
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkGlError();
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.texCoordsHandle);
        GlUtil.checkGlError();
        float[] texMatrix = this.stereoMode == 1 ? (rightEye ? TEX_MATRIX_BOTTOM : TEX_MATRIX_TOP) : (this.stereoMode == 2 ? (rightEye ? TEX_MATRIX_RIGHT : TEX_MATRIX_LEFT) : TEX_MATRIX_WHOLE);
        GLES20.glUniformMatrix3fv((int)this.uTexMatrixHandle, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mvpMatrixHandle, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)textureId);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GlUtil.checkGlError();
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)meshData.vertexBuffer);
        GlUtil.checkGlError();
        GLES20.glVertexAttribPointer((int)this.texCoordsHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)meshData.textureBuffer);
        GlUtil.checkGlError();
        GLES20.glDrawArrays((int)meshData.drawMode, (int)0, (int)meshData.vertexCount);
        GlUtil.checkGlError();
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordsHandle);
    }

    void shutdown() {
        if (this.program != 0) {
            GLES20.glDeleteProgram((int)this.program);
        }
    }

    private static class MeshData {
        private final int vertexCount;
        private final FloatBuffer vertexBuffer;
        private final FloatBuffer textureBuffer;
        private final int drawMode;

        public MeshData(Projection.SubMesh subMesh) {
            this.vertexCount = subMesh.getVertexCount();
            this.vertexBuffer = GlUtil.createBuffer((float[])subMesh.vertices);
            this.textureBuffer = GlUtil.createBuffer((float[])subMesh.textureCoords);
            switch (subMesh.mode) {
                case 1: {
                    this.drawMode = 5;
                    break;
                }
                case 2: {
                    this.drawMode = 6;
                    break;
                }
                default: {
                    this.drawMode = 4;
                }
            }
        }
    }
}

