/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.os.Bundle;
import android.os.ResultReceiver;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;

public class DefaultPlaybackController
implements MediaSessionConnector.PlaybackController {
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    private static final long BASE_ACTIONS = 2359815L;
    protected final long rewindIncrementMs;
    protected final long fastForwardIncrementMs;
    protected final int repeatToggleModes;

    public DefaultPlaybackController() {
        this(5000L, 15000L, 3);
    }

    public DefaultPlaybackController(long rewindIncrementMs, long fastForwardIncrementMs, int repeatToggleModes) {
        this.rewindIncrementMs = rewindIncrementMs;
        this.fastForwardIncrementMs = fastForwardIncrementMs;
        this.repeatToggleModes = repeatToggleModes;
    }

    @Override
    public long getSupportedPlaybackActions(Player player) {
        if (player == null || player.getCurrentTimeline().isEmpty()) {
            return 0L;
        }
        if (!player.isCurrentWindowSeekable()) {
            return 2359815L;
        }
        long actions = 2360071L;
        if (this.fastForwardIncrementMs > 0L) {
            actions |= 0x40L;
        }
        if (this.rewindIncrementMs > 0L) {
            actions |= 8L;
        }
        return actions;
    }

    @Override
    public void onPlay(Player player) {
        player.setPlayWhenReady(true);
    }

    @Override
    public void onPause(Player player) {
        player.setPlayWhenReady(false);
    }

    @Override
    public void onSeekTo(Player player, long position) {
        long duration = player.getDuration();
        if (duration != -9223372036854775807L) {
            position = Math.min(position, duration);
        }
        player.seekTo(Math.max(position, 0L));
    }

    @Override
    public void onFastForward(Player player) {
        if (this.fastForwardIncrementMs <= 0L) {
            return;
        }
        this.onSeekTo(player, player.getCurrentPosition() + this.fastForwardIncrementMs);
    }

    @Override
    public void onRewind(Player player) {
        if (this.rewindIncrementMs <= 0L) {
            return;
        }
        this.onSeekTo(player, player.getCurrentPosition() - this.rewindIncrementMs);
    }

    @Override
    public void onStop(Player player) {
        player.stop(true);
    }

    @Override
    public void onSetShuffleMode(Player player, int shuffleMode) {
        player.setShuffleModeEnabled(shuffleMode == 1 || shuffleMode == 2);
    }

    @Override
    public void onSetRepeatMode(Player player, int repeatMode) {
        int selectedExoPlayerRepeatMode = player.getRepeatMode();
        switch (repeatMode) {
            case 2: 
            case 3: {
                if ((this.repeatToggleModes & 2) == 0) break;
                selectedExoPlayerRepeatMode = 2;
                break;
            }
            case 1: {
                if ((this.repeatToggleModes & 1) == 0) break;
                selectedExoPlayerRepeatMode = 1;
                break;
            }
            default: {
                selectedExoPlayerRepeatMode = 0;
            }
        }
        player.setRepeatMode(selectedExoPlayerRepeatMode);
    }

    @Override
    public String[] getCommands() {
        return null;
    }

    @Override
    public void onCommand(Player player, String command, Bundle extras, ResultReceiver cb) {
    }
}

