/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.base.AutoValue_MapType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.model.Key;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class MapType {
    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredMapType();

    private DeclaredType declaredMapType() {
        return (DeclaredType)this.wrappedDeclaredMapType().get();
    }

    public boolean isRawType() {
        return this.declaredMapType().getTypeArguments().isEmpty();
    }

    public TypeMirror keyType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.declaredMapType().getTypeArguments().get(0);
    }

    public TypeMirror valueType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.declaredMapType().getTypeArguments().get(1);
    }

    public boolean valuesAreTypeOf(Class<?> clazz) {
        return MoreTypes.isType(this.valueType()) && MoreTypes.isTypeOf(clazz, this.valueType());
    }

    public boolean valuesAreFrameworkType() {
        return FrameworkTypes.isFrameworkType(this.valueType());
    }

    public TypeMirror unwrappedFrameworkValueType() {
        Preconditions.checkState((boolean)this.valuesAreFrameworkType(), (String)"called unwrappedFrameworkValueType() on %s", (Object)this.declaredMapType());
        return this.uncheckedUnwrappedValueType();
    }

    public TypeMirror unwrappedValueType(Class<?> wrappingClass) {
        Preconditions.checkArgument((wrappingClass.getTypeParameters().length == 1 ? 1 : 0) != 0, (String)"%s must have exactly one type parameter", wrappingClass);
        Preconditions.checkState((boolean)this.valuesAreTypeOf(wrappingClass), (String)"expected values to be %s: %s", wrappingClass, (Object)this);
        return this.uncheckedUnwrappedValueType();
    }

    private TypeMirror uncheckedUnwrappedValueType() {
        return MoreTypes.asDeclared(this.valueType()).getTypeArguments().get(0);
    }

    public static boolean isMap(TypeMirror type) {
        return MoreTypes.isType(type) && MoreTypes.isTypeOf(Map.class, type);
    }

    public static boolean isMap(Key key) {
        return MapType.isMap(key.type());
    }

    public static MapType from(TypeMirror type) {
        Preconditions.checkArgument((boolean)MapType.isMap(type), (String)"%s is not a Map", (Object)type);
        return new AutoValue_MapType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type)));
    }

    public static MapType from(Key key) {
        return MapType.from(key.type());
    }
}

